/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.spi.ReconGlobalStatsManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.hadoop.ozone.recon.tasks.GlobalStatsValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconGlobalStatsManagerImpl
implements ReconGlobalStatsManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconGlobalStatsManagerImpl.class);
    private Table<String, GlobalStatsValue> globalStatsTable;
    private DBStore globalStatsDbStore;

    @Inject
    public ReconGlobalStatsManagerImpl(ReconDBProvider reconDBProvider) {
        this(reconDBProvider.getDbStore());
    }

    private ReconGlobalStatsManagerImpl(DBStore reconDBStore) {
        this.globalStatsDbStore = reconDBStore;
        this.initializeTables();
    }

    @Override
    public ReconGlobalStatsManager getStagedReconGlobalStatsManager(DBStore stagedReconDbStore) {
        return new ReconGlobalStatsManagerImpl(stagedReconDbStore);
    }

    @Override
    public void reinitialize(ReconDBProvider reconDBProvider) {
        this.globalStatsDbStore = reconDBProvider.getDbStore();
        this.initializeTables();
    }

    private void initializeTables() {
        try {
            this.globalStatsTable = ReconDBDefinition.GLOBAL_STATS.getTable(this.globalStatsDbStore);
        }
        catch (IOException e) {
            LOG.error("Unable to create Global Stats table.", (Throwable)e);
        }
    }

    @Override
    public void batchStoreGlobalStats(BatchOperation batch, String key, GlobalStatsValue value) throws IOException {
        this.globalStatsTable.putWithBatch(batch, (Object)key, (Object)value);
    }

    @Override
    public GlobalStatsValue getGlobalStatsValue(String key) throws IOException {
        return (GlobalStatsValue)this.globalStatsTable.get((Object)key);
    }

    @Override
    public Table<String, GlobalStatsValue> getGlobalStatsTable() {
        return this.globalStatsTable;
    }

    @Override
    public void commitBatchOperation(RDBBatchOperation rdbBatchOperation) throws IOException {
        this.globalStatsDbStore.commitBatchOperation((BatchOperation)rdbBatchOperation);
    }
}

