/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTask;

public class ReconNamespaceSummaryManagerImpl
implements ReconNamespaceSummaryManager {
    private Table<Long, NSSummary> nsSummaryTable;
    private DBStore namespaceDbStore;
    private NSSummaryTask nsSummaryTask;

    @Inject
    public ReconNamespaceSummaryManagerImpl(ReconDBProvider reconDBProvider, NSSummaryTask nsSummaryTask) throws IOException {
        this(reconDBProvider.getDbStore(), nsSummaryTask);
    }

    private ReconNamespaceSummaryManagerImpl(DBStore dbStore, NSSummaryTask nsSummaryTask) throws IOException {
        this.namespaceDbStore = dbStore;
        this.nsSummaryTable = ReconDBDefinition.NAMESPACE_SUMMARY.getTable(this.namespaceDbStore);
        this.nsSummaryTask = nsSummaryTask;
    }

    @Override
    public ReconNamespaceSummaryManager getStagedNsSummaryManager(DBStore dbStore) throws IOException {
        return new ReconNamespaceSummaryManagerImpl(dbStore, this.nsSummaryTask);
    }

    @Override
    public void reinitialize(ReconDBProvider reconDBProvider) throws IOException {
        this.namespaceDbStore = reconDBProvider.getDbStore();
        this.nsSummaryTable = ReconDBDefinition.NAMESPACE_SUMMARY.getTable(this.namespaceDbStore);
    }

    @Override
    public void clearNSSummaryTable() throws IOException {
        ReconDBProvider.truncateTable(this.nsSummaryTable);
    }

    @Override
    public void storeNSSummary(long objectId, NSSummary nsSummary) throws IOException {
        this.nsSummaryTable.put((Object)objectId, (Object)nsSummary);
    }

    @Override
    public void batchStoreNSSummaries(BatchOperation batch, long objectId, NSSummary nsSummary) throws IOException {
        this.nsSummaryTable.putWithBatch(batch, (Object)objectId, (Object)nsSummary);
    }

    @Override
    public void batchDeleteNSSummaries(BatchOperation batch, long objectId) throws IOException {
        this.nsSummaryTable.deleteWithBatch(batch, (Object)objectId);
    }

    @Override
    public void deleteNSSummary(long objectId) throws IOException {
        this.nsSummaryTable.delete((Object)objectId);
    }

    @Override
    public NSSummary getNSSummary(long objectId) throws IOException {
        return (NSSummary)this.nsSummaryTable.get((Object)objectId);
    }

    @Override
    public void commitBatchOperation(RDBBatchOperation rdbBatchOperation) throws IOException {
        this.namespaceDbStore.commitBatchOperation((BatchOperation)rdbBatchOperation);
    }

    public Table getNSSummaryTable() {
        return this.nsSummaryTable;
    }
}

