/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SstFilteringService
extends BackgroundService
implements BootstrapStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SstFilteringService.class);
    private static final int SST_FILTERING_CORE_POOL_SIZE = 1;
    public static final String SST_FILTERED_FILE = "sstFiltered";
    private static final byte[] SST_FILTERED_FILE_CONTENT = StringUtils.string2Bytes((String)"This file holds information if a particular snapshot has filtered out the relevant sst files or not.\nDO NOT add, change or delete any files in this directory unless you know what you are doing.\n");
    private final OzoneManager ozoneManager;
    private final long snapshotLimitPerTask;
    private AtomicLong snapshotFilteredCount;
    private AtomicBoolean running;
    private final BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();

    public static boolean isSstFiltered(OzoneConfiguration ozoneConfiguration, SnapshotInfo snapshotInfo) {
        Path sstFilteredFile = Paths.get(OmSnapshotManager.getSnapshotPath(ozoneConfiguration, snapshotInfo), SST_FILTERED_FILE);
        return snapshotInfo.isSstFiltered() || sstFilteredFile.toFile().exists();
    }

    public SstFilteringService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration) {
        super("SstFilteringService", interval, unit, 1, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.snapshotLimitPerTask = configuration.getLong("ozone.snapshot.filtering.limit.per.task", 2L);
        this.snapshotFilteredCount = new AtomicLong(0L);
        this.running = new AtomicBoolean(false);
    }

    public void start() {
        this.running.set(true);
        super.start();
    }

    @VisibleForTesting
    public void pause() {
        this.running.set(false);
    }

    @VisibleForTesting
    public void resume() {
        this.running.set(true);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SstFilteringTask());
        return queue;
    }

    public AtomicLong getSnapshotFilteredCount() {
        return this.snapshotFilteredCount;
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    public void shutdown() {
        this.running.set(false);
        super.shutdown();
    }

    private class SstFilteringTask
    implements BackgroundTask {
        private SstFilteringTask() {
        }

        private boolean isSnapshotDeleted(SnapshotInfo snapshotInfo) {
            return snapshotInfo == null || snapshotInfo.getSnapshotStatus() == SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED;
        }

        private void markSSTFilteredFlagForSnapshot(SnapshotInfo snapshotInfo) throws IOException {
            OMLockDetails omLockDetails = SstFilteringService.this.ozoneManager.getMetadataManager().getLock().acquireReadLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
            boolean acquiredSnapshotLock = omLockDetails.isLockAcquired();
            if (acquiredSnapshotLock) {
                String snapshotDir = OmSnapshotManager.getSnapshotPath(SstFilteringService.this.ozoneManager.getConfiguration(), snapshotInfo);
                try {
                    if (Files.exists(Paths.get(snapshotDir, new String[0]), new LinkOption[0])) {
                        Files.write(Paths.get(snapshotDir, SstFilteringService.SST_FILTERED_FILE), SST_FILTERED_FILE_CONTENT, new OpenOption[0]);
                    }
                }
                catch (Throwable throwable) {
                    SstFilteringService.this.ozoneManager.getMetadataManager().getLock().releaseReadLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
                    throw throwable;
                }
                SstFilteringService.this.ozoneManager.getMetadataManager().getLock().releaseReadLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
            }
        }

        public BackgroundTaskResult call() throws Exception {
            Optional<OmSnapshotManager> snapshotManager = Optional.ofNullable(SstFilteringService.this.ozoneManager).map(OzoneManager::getOmSnapshotManager);
            if (!snapshotManager.isPresent()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            Table snapshotInfoTable = SstFilteringService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Table.KeyValueIterator iterator = snapshotInfoTable.iterator();){
                    iterator.seekToFirst();
                    long snapshotLimit = SstFilteringService.this.snapshotLimitPerTask;
                    while (iterator.hasNext() && snapshotLimit > 0L && SstFilteringService.this.running.get()) {
                        Table.KeyValue keyValue = (Table.KeyValue)iterator.next();
                        String snapShotTableKey = (String)keyValue.getKey();
                        SnapshotInfo snapshotInfo = (SnapshotInfo)keyValue.getValue();
                        try {
                            if (SstFilteringService.isSstFiltered(SstFilteringService.this.ozoneManager.getConfiguration(), snapshotInfo)) continue;
                            LOG.debug("Processing snapshot {} to filter relevant SST Files", (Object)snapShotTableKey);
                            Map<String, String> columnFamilyNameToPrefixMap = SnapshotUtils.getColumnFamilyToKeyPrefixMap(SstFilteringService.this.ozoneManager.getMetadataManager(), snapshotInfo.getVolumeName(), snapshotInfo.getBucketName());
                            try {
                                Throwable throwable2 = null;
                                Object var13_18 = null;
                                try (UncheckedAutoCloseableSupplier<OmSnapshot> snapshotMetadataReader = snapshotManager.get().getActiveSnapshot(snapshotInfo.getVolumeName(), snapshotInfo.getBucketName(), snapshotInfo.getName());){
                                    OmSnapshot omSnapshot = (OmSnapshot)snapshotMetadataReader.get();
                                    RDBStore rdbStore = (RDBStore)omSnapshot.getMetadataManager().getStore();
                                    RocksDatabase db = rdbStore.getDb();
                                    Throwable throwable3 = null;
                                    Object var19_26 = null;
                                    try (BootstrapStateHandler.Lock lock = SstFilteringService.this.getBootstrapStateLock().lock();){
                                        db.deleteFilesNotMatchingPrefix(columnFamilyNameToPrefixMap);
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                    this.markSSTFilteredFlagForSnapshot(snapshotInfo);
                                    --snapshotLimit;
                                    SstFilteringService.this.snapshotFilteredCount.getAndIncrement();
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (OMException ome) {
                                SnapshotInfo snapshotInfoToCheck;
                                if (ome.getResult() != OMException.ResultCodes.FILE_NOT_FOUND || !this.isSnapshotDeleted(snapshotInfoToCheck = (SnapshotInfo)SstFilteringService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable().get((Object)snapShotTableKey))) continue;
                                LOG.info("Snapshot with name: '{}', id: '{}' has been deleted.", (Object)snapshotInfo.getName(), (Object)snapshotInfo.getSnapshotId());
                            }
                        }
                        catch (IOException e) {
                            if (this.isSnapshotDeleted((SnapshotInfo)snapshotInfoTable.get((Object)snapShotTableKey))) {
                                LOG.info("Exception encountered while filtering a snapshot: {} since it was deleted midway", (Object)snapShotTableKey, (Object)e);
                                continue;
                            }
                            LOG.error("Exception encountered while filtering a snapshot", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error("Error during Snapshot sst filtering ", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

