/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequestWithFSO
extends OMFileCreateRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileCreateRequestWithFSO.class);

    public OMFileCreateRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        int numKeysCreated;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest;
        block19: {
            long trxnLogIndex = context.getIndex();
            createFileRequest = this.getOmRequest().getCreateFileRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            boolean isRecursive = createFileRequest.getIsRecursive();
            if (LOG.isDebugEnabled()) {
                LOG.debug("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
            }
            boolean isOverWrite = createFileRequest.getIsOverwrite();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateFile();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            numKeysCreated = 0;
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            try {
                try {
                    if (keyName.isEmpty()) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    OmKeyInfo dbFileInfo = null;
                    OMFileRequest.OMPathInfoWithFSO pathInfoFSO = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    if (pathInfoFSO.getDirectoryResult() == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
                        String dbFileKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName());
                        dbFileInfo = OMFileRequest.getOmKeyInfoFromFileTable(false, omMetadataManager, dbFileKey, keyName);
                    }
                    this.checkDirectoryResult(keyName, isOverWrite, pathInfoFSO.getDirectoryResult());
                    if (!isRecursive) {
                        this.checkAllParentsExist(keyArgs, pathInfoFSO);
                    }
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    List<OmDirectoryInfo> missingParentInfos = this.getAllMissingParentDirInfo(ozoneManager, keyArgs, bucketInfo, pathInfoFSO, trxnLogIndex);
                    numKeysCreated = missingParentInfos.size();
                    ReplicationConfig repConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), bucketInfo.getDefaultReplicationConfig(), ozoneManager);
                    OmKeyInfo omFileInfo = this.prepareFileInfo(omMetadataManager, keyArgs, dbFileInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, pathInfoFSO, trxnLogIndex, pathInfoFSO.getLeafNodeObjectId(), repConfig, ozoneManager.getConfig());
                    this.validateEncryptionKeyInfo(bucketInfo, keyArgs);
                    long openVersion = omFileInfo.getLatestVersionLocations().getVersion();
                    long clientID = createFileRequest.getClientID();
                    String dbOpenFileName = omMetadataManager.getOpenFileName(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName(), clientID);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omFileInfo.appendNewBlocks(newLocationList, false);
                    omBucketInfo = OMFileCreateRequestWithFSO.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)repConfig.getRequiredNodes();
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(omBucketInfo, (long)numKeysCreated + 1L);
                    omBucketInfo.incrUsedNamespace((long)numKeysCreated);
                    OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileName, omFileInfo, pathInfoFSO.getLeafNodeName(), keyName, trxnLogIndex);
                    OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, volumeId, bucketId, trxnLogIndex, missingParentInfos, null);
                    int clientVersion = this.getOmRequest().getVersion();
                    omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omFileInfo.getNetworkProtobuf(keyName, clientVersion, keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponseWithFSO(omResponse.build(), omFileInfo, missingParentInfos, clientID, omBucketInfo.copyObject(), volumeId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumCreateFileFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numKeysCreated);
                LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("File create failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }
}

