/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysDeleteRequest.class);
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;

    public OMKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        block21: {
            block19: {
                block20: {
                    trxnLogIndex = context.getIndex();
                    deleteKeyRequest = this.getOmRequest().getDeleteKeysRequest();
                    deleteKeyArgs = deleteKeyRequest.getDeleteKeys();
                    deleteKeys = new ArrayList<E>(deleteKeyArgs.getKeysList());
                    deleteKeysInfo = new ArrayList<OmKeyInfo>();
                    exception = null;
                    omClientResponse = null;
                    result = null;
                    keyToError = new HashMap<String, ErrorInfo>();
                    omMetrics = ozoneManager.getMetrics();
                    omMetrics.incNumKeyDeletes();
                    perfMetrics = ozoneManager.getPerfMetrics();
                    volumeName = deleteKeyArgs.getVolumeName();
                    bucketName = deleteKeyArgs.getBucketName();
                    auditMap = new LinkedHashMap<String, String>();
                    auditMap.put("volume", volumeName);
                    auditMap.put("bucket", bucketName);
                    omKeyInfoList = new ArrayList<OmKeyInfo>();
                    dirList = new ArrayList<OmKeyInfo>();
                    auditLogger = ozoneManager.getAuditLogger();
                    userInfo = this.getOmRequest().getUserInfo();
                    omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                    omMetadataManager = ozoneManager.getMetadataManager();
                    acquiredLock = false;
                    indexFailed = 0;
                    length = deleteKeys.size();
                    unDeletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setVolumeName(volumeName).setBucketName(bucketName);
                    deleteStatus = true;
                    startNanos = Time.monotonicNowNanos();
                    try {
                        try {
                            startNanosDeleteKeysResolveBucketLatency = Time.monotonicNowNanos();
                            bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
                            perfMetrics.setDeleteKeysResolveBucketLatencyNs(Time.monotonicNowNanos() - startNanosDeleteKeysResolveBucketLatency);
                            bucket.audit(auditMap);
                            volumeName = bucket.realVolume();
                            bucketName = bucket.realBucket();
                            this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                            acquiredLock = this.getOmLockDetails().isLockAcquired();
                            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                            volumeOwner = this.getVolumeOwner(omMetadataManager, volumeName);
                            indexFailed = 0;
                            while (indexFailed < length) {
                                keyName = deleteKeyArgs.getKeys(indexFailed);
                                objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                                omKeyInfo = this.getOmKeyInfo(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
                                if (omKeyInfo == null) {
                                    deleteStatus = false;
                                    OMKeysDeleteRequest.LOG.error("Received a request to delete a Key does not exist {}", (Object)objectKey);
                                    deleteKeys.remove(keyName);
                                    unDeletedKeys.addKeys(keyName);
                                    keyToError.put(keyName, new ErrorInfo(OMException.ResultCodes.KEY_NOT_FOUND.name(), "Key does not exist"));
                                } else {
                                    try {
                                        startNanosDeleteKeysAclCheckLatency = Time.monotonicNowNanos();
                                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY, volumeOwner);
                                        perfMetrics.setDeleteKeysAclCheckLatencyNs(Time.monotonicNowNanos() - startNanosDeleteKeysAclCheckLatency);
                                        fileStatus = this.getOzoneKeyStatus(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
                                        this.addKeyToAppropriateList(omKeyInfoList, omKeyInfo, dirList, fileStatus);
                                        deleteKeysInfo.add(omKeyInfo);
                                    }
                                    catch (Exception ex) {
                                        deleteStatus = false;
                                        OMKeysDeleteRequest.LOG.error("Acl check failed for Key: {}", (Object)objectKey, (Object)ex);
                                        deleteKeys.remove(keyName);
                                        unDeletedKeys.addKeys(keyName);
                                        keyToError.put(keyName, new ErrorInfo(OMException.ResultCodes.ACCESS_DENIED.name(), "ACL check failed"));
                                    }
                                }
                                ++indexFailed;
                            }
                            omBucketInfo = OMKeysDeleteRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                            openKeyInfoMap = new HashMap<String, OmKeyInfo>();
                            quotaReleasedEmptyKeys = this.markKeysAsDeletedInCache(ozoneManager, trxnLogIndex, omKeyInfoList, dirList, omMetadataManager, openKeyInfoMap);
                            omBucketInfo.decrUsedBytes(((Long)quotaReleasedEmptyKeys.getKey()).longValue(), true);
                            omBucketInfo.decrUsedNamespace((long)(omKeyInfoList.size() + dirList.size() - (Integer)quotaReleasedEmptyKeys.getValue()), true);
                            omBucketInfo.decrUsedNamespace((long)((Integer)quotaReleasedEmptyKeys.getValue()).intValue(), false);
                            volumeId = omMetadataManager.getVolumeId(volumeName);
                            omClientResponse = this.getOmClientResponse(ozoneManager, omKeyInfoList, dirList, omResponse, unDeletedKeys, keyToError, deleteStatus, omBucketInfo, volumeId, openKeyInfoMap);
                            result = OMClientRequest.Result.SUCCESS;
                            endNanosDeleteKeySuccessLatencyNs = Time.monotonicNowNanos();
                            perfMetrics.setDeleteKeySuccessLatencyNs(endNanosDeleteKeySuccessLatencyNs - startNanos);
                            break block19;
                        }
                        catch (IOException | InvalidPathException ex) {
                            result = OMClientRequest.Result.FAILURE;
                            exception = ex;
                            this.createErrorOMResponse(omResponse, exception);
                            deleteKeys = new ArrayList<E>();
                            deleteKeysInfo.clear();
                            i = indexFailed;
                            ** while (i < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            unDeletedKeys.addKeys(deleteKeyArgs.getKeys(i));
                            keyToError.put(deleteKeyArgs.getKeys(i), new ErrorInfo(OMException.ResultCodes.INTERNAL_ERROR.name(), ex.getMessage()));
                            ++i;
                            continue;
                        }
lbl107:
                        // 1 sources

                        omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(false).setUnDeletedKeys(unDeletedKeys).build()).build();
                        omClientResponse = new OMKeysDeleteResponse(omResponse.build(), this.getBucketLayout());
                        endNanosDeleteKeyFailureLatencyNs = Time.monotonicNowNanos();
                        perfMetrics.setDeleteKeyFailureLatencyNs(endNanosDeleteKeyFailureLatencyNs - startNanos);
                        if (!acquiredLock) break block20;
                    }
                    catch (Throwable var42_42) {
                        if (acquiredLock) {
                            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                        }
                        if (omClientResponse != null) {
                            omClientResponse.setOmLockDetails(this.getOmLockDetails());
                        }
                        throw var42_42;
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                break block21;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OMKeysDeleteRequest.addDeletedKeys(auditMap, deleteKeysInfo, unDeletedKeys.getKeysList());
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.DELETE_KEYS, auditMap, exception, userInfo));
        switch (OMKeysDeleteRequest.$SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result()[result.ordinal()]) {
            case 1: {
                omMetrics.decNumKeys(deleteKeys.size());
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete success. Volume:{}, Bucket:{}, Keys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList")});
                break;
            }
            case 2: {
                omMetrics.incNumKeyDeleteFails();
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete failed. Volume:{}, Bucket:{}, DeletedKeys:{}, UnDeletedKeys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList"), auditMap.get("unDeletedKeysList"), exception});
                break;
            }
            default: {
                OMKeysDeleteRequest.LOG.error("Unrecognized Result for OMKeysDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    protected OzoneFileStatus getOzoneKeyStatus(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return null;
    }

    @Nonnull
    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OzoneManagerProtocolProtos.DeleteKeyArgs.Builder unDeletedKeys, Map<String, ErrorInfo> keyToErrors, boolean deleteStatus, OmBucketInfo omBucketInfo, long volumeId, Map<String, OmKeyInfo> openKeyInfoMap) {
        ArrayList<OzoneManagerProtocolProtos.DeleteKeyError> deleteKeyErrors = new ArrayList<OzoneManagerProtocolProtos.DeleteKeyError>();
        for (Map.Entry<String, ErrorInfo> key : keyToErrors.entrySet()) {
            deleteKeyErrors.add(OzoneManagerProtocolProtos.DeleteKeyError.newBuilder().setKey(key.getKey()).setErrorCode(key.getValue().getCode()).setErrorMsg(key.getValue().getMessage()).build());
        }
        OMKeysDeleteResponse omClientResponse = new OMKeysDeleteResponse(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys).addAllErrors(deleteKeyErrors)).setStatus(deleteStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, omBucketInfo.copyObject(), openKeyInfoMap);
        return omClientResponse;
    }

    protected Pair<Long, Integer> markKeysAsDeletedInCache(OzoneManager ozoneManager, long trxnLogIndex, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OMMetadataManager omMetadataManager, Map<String, OmKeyInfo> openKeyInfoMap) throws IOException {
        int emptyKeys = 0;
        long quotaReleased = 0L;
        for (OmKeyInfo omKeyInfo : omKeyInfoList) {
            String dbOpenKey;
            String volumeName = omKeyInfo.getVolumeName();
            String bucketName = omKeyInfo.getBucketName();
            String keyName = omKeyInfo.getKeyName();
            omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyName)), CacheValue.get((long)trxnLogIndex));
            omKeyInfo.setUpdateID(trxnLogIndex);
            quotaReleased += OMKeysDeleteRequest.sumBlockLengths(omKeyInfo);
            emptyKeys += OmKeyInfo.isKeyEmpty((OmKeyInfo)omKeyInfo) ? 1 : 0;
            String hsyncClientId = (String)omKeyInfo.getMetadata().get("hsyncClientId");
            if (hsyncClientId == null) continue;
            Table openKeyTable = omMetadataManager.getOpenKeyTable(this.getBucketLayout());
            OmKeyInfo openKeyInfo = (OmKeyInfo)openKeyTable.get((Object)(dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, hsyncClientId)));
            if (openKeyInfo != null) {
                openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                openKeyTable.addCacheEntry((Object)dbOpenKey, (Object)openKeyInfo, trxnLogIndex);
                openKeyInfoMap.put(dbOpenKey, openKeyInfo);
                continue;
            }
            LOG.warn("Potentially inconsistent DB state: open key not found with dbOpenKey '{}'", (Object)dbOpenKey);
        }
        return Pair.of((Object)quotaReleased, (Object)emptyKeys);
    }

    protected void addKeyToAppropriateList(List<OmKeyInfo> omKeyInfoList, OmKeyInfo omKeyInfo, List<OmKeyInfo> dirList, OzoneFileStatus keyStatus) {
        omKeyInfoList.add(omKeyInfo);
    }

    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volume, String bucket, String key) throws IOException {
        String objectKey = omMetadataManager.getOzoneKey(volume, bucket, key);
        return (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)objectKey);
    }

    protected static void addDeletedKeys(Map<String, String> auditMap, List<OmKeyInfo> deletedKeyInfos, List<String> unDeletedKeys) {
        StringBuilder keys = new StringBuilder();
        int i = 0;
        while (i < deletedKeyInfos.size()) {
            OmKeyInfo key = deletedKeyInfos.get(i);
            keys.append('{').append("key").append('=').append(key.getKeyName()).append(", ");
            keys.append("dataSize").append('=').append(key.getDataSize()).append(", ");
            keys.append("replicationConfig").append('=').append(key.getReplicationConfig()).append('}');
            if (i < deletedKeyInfos.size() - 1) {
                keys.append(", ");
            }
            ++i;
        }
        auditMap.put("deletedKeysList", keys.toString());
        auditMap.put("unDeletedKeysList", String.join((CharSequence)",", unDeletedKeys));
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.DeleteKeys)
    public static OzoneManagerProtocolProtos.OMRequest blockDeleteKeysWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyArgs keyArgs;
        if (req.getDeleteKeysRequest().hasDeleteKeys() && (keyArgs = req.getDeleteKeysRequest().getDeleteKeys()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result() {
        if ($SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result != null) {
            return $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;
        }
        int[] nArray = new int[OMClientRequest.Result.values().length];
        try {
            nArray[OMClientRequest.Result.FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OMClientRequest.Result.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result = nArray;
        return nArray;
    }
}

