/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeDeleteRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeDeleteRequest.class);

    public OMVolumeDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientResponse omClientResponse;
        String owner;
        Exception exception;
        OMMetrics omMetrics;
        String volume;
        block19: {
            long transactionLogIndex = context.getIndex();
            OzoneManagerProtocolProtos.DeleteVolumeRequest deleteVolumeRequest = this.getOmRequest().getDeleteVolumeRequest();
            Preconditions.checkNotNull((Object)deleteVolumeRequest);
            volume = deleteVolumeRequest.getVolumeName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeDeletes();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredUserLock = false;
            boolean acquiredVolumeLock = false;
            exception = null;
            owner = null;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    OmVolumeArgs omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
                    long volRefCount = omVolumeArgs.getRefCount();
                    if (volRefCount != 0L) {
                        LOG.debug("volume: {} has a non-zero ref count. won't delete", (Object)volume);
                        throw new OMException("Volume reference count is not zero (" + volRefCount + "). Ozone features are enabled on this volume. " + "Try `ozone tenant delete <tenantId>` first.", OMException.ResultCodes.VOLUME_IS_REFERENCED);
                    }
                    owner = omVolumeArgs.getOwnerName();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                    acquiredUserLock = this.getOmLockDetails().isLockAcquired();
                    String dbUserKey = omMetadataManager.getUserKey(owner);
                    String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                    if (!omMetadataManager.isVolumeEmpty(volume)) {
                        LOG.debug("volume:{} is not empty", (Object)volume);
                        throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
                    }
                    OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)owner);
                    newVolumeList = this.delVolumeFromOwnerList(newVolumeList, volume, owner, transactionLogIndex);
                    omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), CacheValue.get((long)transactionLogIndex, (Object)newVolumeList));
                    omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), CacheValue.get((long)transactionLogIndex));
                    omResponse.setDeleteVolumeResponse(OzoneManagerProtocolProtos.DeleteVolumeResponse.newBuilder().build());
                    omClientResponse = new OMVolumeDeleteResponse(omResponse.build(), volume, owner, newVolumeList);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMVolumeDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredUserLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                    }
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (acquiredUserLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                }
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredUserLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.DELETE_VOLUME, this.buildVolumeAuditMap(volume), exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.debug("Volume deleted for user:{} volume:{}", (Object)owner, (Object)volume);
            omMetrics.decNumVolumes();
        } else {
            LOG.error("Volume deletion failed for user:{} volume:{}", new Object[]{owner, volume, exception});
            omMetrics.incNumVolumeDeleteFails();
        }
        return omClientResponse;
    }
}

