/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable", "openFileTable", "directoryTable", "deletedTable", "deletedDirectoryTable", "bucketTable"})
public class OMKeyDeleteResponseWithFSO
extends OMKeyDeleteResponse {
    private boolean isDeleteDirectory;
    private String keyName;
    private long volumeId;

    public OMKeyDeleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String keyName, @Nonnull OmKeyInfo omKeyInfo, @Nonnull OmBucketInfo omBucketInfo, @Nonnull boolean isDeleteDirectory, @Nonnull long volumeId, OmKeyInfo deletedOpenKeyInfo) {
        super(omResponse, omKeyInfo, omBucketInfo, deletedOpenKeyInfo);
        this.keyName = keyName;
        this.isDeleteDirectory = isDeleteDirectory;
        this.volumeId = volumeId;
    }

    public OMKeyDeleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String hsyncClientId;
        String ozoneDbKey = omMetadataManager.getOzonePathKey(this.volumeId, this.getOmBucketInfo().getObjectID(), this.getOmKeyInfo().getParentObjectID(), this.getOmKeyInfo().getFileName());
        if (this.isDeleteDirectory) {
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
            OmKeyInfo omKeyInfo = this.getOmKeyInfo();
            omKeyInfo.setKeyName(this.keyName);
            String ozoneDeleteKey = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), ozoneDbKey);
            omMetadataManager.getDeletedDirTable().putWithBatch(batchOperation, (Object)ozoneDeleteKey, (Object)omKeyInfo);
        } else {
            Table keyTable = omMetadataManager.getKeyTable(this.getBucketLayout());
            OmKeyInfo omKeyInfo = this.getOmKeyInfo();
            omKeyInfo.setKeyName(this.keyName);
            String deletedKey = omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName());
            deletedKey = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), deletedKey);
            this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, ozoneDbKey, deletedKey, omKeyInfo, this.getOmBucketInfo().getObjectID(), true);
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName()), (Object)this.getOmBucketInfo());
        OmKeyInfo deletedOpenKeyInfo = this.getDeletedOpenKeyInfo();
        if (deletedOpenKeyInfo != null && (hsyncClientId = (String)this.getDeletedOpenKeyInfo().getMetadata().get("hsyncClientId")) != null) {
            String dbOpenKey = omMetadataManager.getOpenKey(deletedOpenKeyInfo.getVolumeName(), deletedOpenKeyInfo.getBucketName(), deletedOpenKeyInfo.getKeyName(), hsyncClientId);
            omMetadataManager.getOpenKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)dbOpenKey, (Object)deletedOpenKeyInfo);
        }
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

