/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.ozone.fs.http.server.HttpFSServerWebApp;
import org.apache.ozone.hdfs.web.WebHdfsConstants;

@InterfaceAudience.Private
public class HttpFSAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    static final String CONF_PREFIX = "httpfs.authentication.";
    static final String HADOOP_HTTP_CONF_PREFIX = "hadoop.http.authentication.";
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        String name;
        Properties props = new Properties();
        Configuration conf = HttpFSServerWebApp.get().getConfig();
        props.setProperty("cookie.path", "/");
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith(HADOOP_HTTP_CONF_PREFIX)) continue;
            name = name.substring(HADOOP_HTTP_CONF_PREFIX.length());
            props.setProperty(name, (String)entry.getValue());
        }
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith(CONF_PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(CONF_PREFIX.length());
            props.setProperty(name, value);
        }
        String signatureSecretFile = props.getProperty(SIGNATURE_SECRET_FILE, null);
        if (signatureSecretFile == null) {
            throw new RuntimeException("Undefined property: signature.secret.file");
        }
        if (!this.isRandomSecret(filterConfig)) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(signatureSecretFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                StringBuilder secret = new StringBuilder();
                int c = ((Reader)reader).read();
                while (c > -1) {
                    secret.append((char)c);
                    c = ((Reader)reader).read();
                }
                props.setProperty("signature.secret", secret.toString());
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read HttpFS signature secret file: " + signatureSecretFile);
            }
        }
        this.setAuthHandlerClass(props);
        String dtkind = WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString();
        if (conf.getBoolean("httpfs.ssl.enabled", false)) {
            dtkind = WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString();
        }
        props.setProperty("delegation-token.token-kind", dtkind);
        return props;
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Map proxyuserConf = HttpFSServerWebApp.get().getConfig().getValByRegex("httpfs\\.proxyuser\\.");
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : proxyuserConf.entrySet()) {
            conf.set(((String)entry.getKey()).substring("httpfs.".length()), (String)entry.getValue());
        }
        return conf;
    }

    private boolean isRandomSecret(FilterConfig filterConfig) {
        SignerSecretProvider secretProvider = (SignerSecretProvider)filterConfig.getServletContext().getAttribute("signer.secret.provider.object");
        if (secretProvider == null) {
            return false;
        }
        return secretProvider.getClass() == RandomSignerSecretProvider.class;
    }
}

