/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.MisReplicationHandler;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public class RatisMisReplicationHandler
extends MisReplicationHandler {
    public RatisMisReplicationHandler(PlacementPolicy containerPlacement, ConfigurationSource conf, ReplicationManager replicationManager) {
        super(containerPlacement, conf, replicationManager);
    }

    @Override
    protected ContainerReplicaCount getContainerReplicaCount(ContainerInfo containerInfo, Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, int minHealthyForMaintenance) throws IOException {
        if (containerInfo.getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            throw new IOException(String.format("Invalid Container Replication Type : %s.Expected Container Replication Type : RATIS", containerInfo.getReplicationType().toString()));
        }
        return new RatisContainerReplicaCount(containerInfo, replicas, pendingOps, minHealthyForMaintenance, true);
    }

    @Override
    protected int sendReplicateCommands(ContainerInfo containerInfo, Set<ContainerReplica> replicasToBeReplicated, List<DatanodeDetails> sources, List<DatanodeDetails> targetDns) throws CommandTargetOverloadedException, NotLeaderException {
        ReplicationManager replicationManager = this.getReplicationManager();
        long containerID = containerInfo.getContainerID();
        int commandsSent = 0;
        for (DatanodeDetails target : targetDns) {
            if (replicationManager.getConfig().isPush()) {
                replicationManager.sendThrottledReplicationCommand(containerInfo, sources, target, 0);
            } else {
                ReplicateContainerCommand cmd = ReplicateContainerCommand.fromSources((long)containerID, sources);
                replicationManager.sendDatanodeCommand((SCMCommand<?>)cmd, containerInfo, target);
            }
            ++commandsSent;
        }
        return commandsSent;
    }
}

