/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ECContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECReplicationCheckHandler
extends AbstractCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ECReplicationCheckHandler.class);

    @Override
    public boolean handle(ContainerCheckRequest request) {
        if (request.getContainerInfo().getReplicationType() != HddsProtos.ReplicationType.EC) {
            return false;
        }
        ReplicationManagerReport report = request.getReport();
        ContainerInfo container = request.getContainerInfo();
        ContainerID containerID = container.containerID();
        ContainerHealthResult health = this.checkHealth(request);
        LOG.debug("Checking container {} in ECReplicationCheckHandler", (Object)container);
        if (health.getHealthState() == ContainerHealthResult.HealthState.HEALTHY) {
            return false;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.UNDER_REPLICATED) {
            ContainerHealthResult.UnderReplicatedHealthResult underHealth = (ContainerHealthResult.UnderReplicatedHealthResult)health;
            if (underHealth.isUnrecoverable()) {
                if (underHealth.isMissing()) {
                    report.incrementAndSample(ReplicationManagerReport.HealthState.MISSING, containerID);
                } else {
                    report.incrementAndSample(ReplicationManagerReport.HealthState.UNHEALTHY, containerID);
                }
                if (underHealth.hasUnreplicatedOfflineIndexes()) {
                    report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, containerID);
                }
            } else {
                report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, containerID);
            }
            if (!underHealth.isReplicatedOkAfterPending() && (!underHealth.isUnrecoverable() || underHealth.hasUnreplicatedOfflineIndexes() && !underHealth.offlineIndexesOkAfterPending())) {
                request.getReplicationQueue().enqueue(underHealth);
            }
            LOG.debug("Container {} is Under Replicated. isReplicatedOkAfterPending is [{}]. isUnrecoverable is [{}]. isMissing is [{}]. hasUnreplicatedOfflineIndexes is [{}]", new Object[]{container, underHealth.isReplicatedOkAfterPending(), underHealth.isUnrecoverable(), underHealth.isMissing(), underHealth.hasUnreplicatedOfflineIndexes()});
            return true;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.OVER_REPLICATED) {
            report.incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, containerID);
            ContainerHealthResult.OverReplicatedHealthResult overHealth = (ContainerHealthResult.OverReplicatedHealthResult)health;
            if (!overHealth.isReplicatedOkAfterPending()) {
                request.getReplicationQueue().enqueue(overHealth);
            }
            LOG.debug("Container {} is Over Replicated. isReplicatedOkAfterPending is [{}]", (Object)container, (Object)overHealth.isReplicatedOkAfterPending());
            return true;
        }
        LOG.warn("Container {} is not healthy but is not under or over replicated. Should not happen.", (Object)container);
        return false;
    }

    public ContainerHealthResult checkHealth(ContainerCheckRequest request) {
        ContainerInfo container = request.getContainerInfo();
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        List<ContainerReplicaOp> replicaPendingOps = request.getPendingOps();
        ECContainerReplicaCount replicaCount = new ECContainerReplicaCount(container, replicas, replicaPendingOps, request.getMaintenanceRedundancy());
        ECReplicationConfig repConfig = (ECReplicationConfig)container.getReplicationConfig();
        if (!replicaCount.isSufficientlyReplicated(false)) {
            List<Integer> missingIndexes = replicaCount.unavailableIndexes(false);
            int remainingRedundancy = repConfig.getParity();
            boolean dueToOutOfService = true;
            if (!missingIndexes.isEmpty()) {
                dueToOutOfService = false;
                remainingRedundancy = repConfig.getParity() - missingIndexes.size();
            }
            ContainerHealthResult.UnderReplicatedHealthResult result = new ContainerHealthResult.UnderReplicatedHealthResult(container, remainingRedundancy, dueToOutOfService, replicaCount.isSufficientlyReplicated(true), replicaCount.isUnrecoverable());
            if (!replicaCount.decommissioningOnlyIndexes(false).isEmpty() || !replicaCount.maintenanceOnlyIndexes(false).isEmpty()) {
                result.setHasUnReplicatedOfflineIndexes(true);
                if (replicaCount.decommissioningOnlyIndexes(true).isEmpty() && replicaCount.maintenanceOnlyIndexes(true).isEmpty()) {
                    result.setOfflineIndexesOkAfterPending(true);
                }
            }
            result.setIsMissing(replicaCount.isMissing());
            return result;
        }
        if (replicaCount.isOverReplicated(false)) {
            List<Integer> overRepIndexes = replicaCount.overReplicatedIndexes(false);
            return new ContainerHealthResult.OverReplicatedHealthResult(container, overRepIndexes.size(), !replicaCount.isOverReplicated(true));
        }
        return new ContainerHealthResult.HealthyResult(container);
    }
}

