/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackgroundSCMService
implements SCMService {
    private final Logger log;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread backgroundThread;
    private final Lock serviceLock = new ReentrantLock();
    private final SCMContext scmContext;
    private SCMService.ServiceStatus serviceStatus = SCMService.ServiceStatus.PAUSING;
    private final long intervalInMillis;
    private final long waitTimeInMillis;
    private long lastTimeToBeReadyInMillis = 0L;
    private final Clock clock;
    private final String serviceName;
    private final Runnable periodicalTask;
    private volatile boolean runImmediately = false;

    private BackgroundSCMService(Builder b) {
        this.scmContext = b.scmContext;
        this.clock = b.clock;
        this.periodicalTask = b.periodicalTask;
        this.serviceName = b.serviceName;
        this.log = LoggerFactory.getLogger((String)this.serviceName);
        this.intervalInMillis = b.intervalInMillis;
        this.waitTimeInMillis = b.waitTimeInMillis;
        this.start();
    }

    @Override
    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            this.log.info("{} Service is already running, skip start.", (Object)this.getServiceName());
            return;
        }
        this.log.info("Starting {} Service.", (Object)this.getServiceName());
        this.backgroundThread = new Thread(this::run);
        this.backgroundThread.setName(this.scmContext.threadNamePrefix() + this.serviceName);
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
    }

    @Override
    public void notifyStatusChanged() {
        this.serviceLock.lock();
        try {
            if (this.scmContext.isLeaderReady() && !this.scmContext.isInSafeMode()) {
                if (this.serviceStatus != SCMService.ServiceStatus.RUNNING) {
                    this.log.info("Service {} transitions to RUNNING.", (Object)this.getServiceName());
                    this.serviceStatus = SCMService.ServiceStatus.RUNNING;
                    this.lastTimeToBeReadyInMillis = this.clock.millis();
                }
            } else if (this.serviceStatus != SCMService.ServiceStatus.PAUSING) {
                this.log.info("Service {} transitions to PAUSING.", (Object)this.getServiceName());
                this.serviceStatus = SCMService.ServiceStatus.PAUSING;
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.running.get()) {
            try {
                if (this.shouldRun()) {
                    try {
                        this.periodicalTask.run();
                    }
                    catch (Throwable e) {
                        this.log.error("Caught Unhandled exception in {}. The task will be re-tried in {}ms", new Object[]{this.getServiceName(), this.intervalInMillis, e});
                    }
                }
                BackgroundSCMService e = this;
                synchronized (e) {
                    if (!this.runImmediately) {
                        this.wait(this.intervalInMillis);
                    }
                    this.runImmediately = false;
                }
            }
            catch (InterruptedException e) {
                this.log.warn("{} is interrupted, exit", (Object)this.serviceName);
                Thread.currentThread().interrupt();
                this.running.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        BackgroundSCMService backgroundSCMService = this;
        synchronized (backgroundSCMService) {
            if (!this.running.compareAndSet(true, false)) {
                this.log.info("{} Service is not running, skip stop.", (Object)this.getServiceName());
                return;
            }
        }
        this.backgroundThread.interrupt();
        this.log.info("Stopping {} Service.", (Object)this.getServiceName());
    }

    @Override
    public boolean shouldRun() {
        this.serviceLock.lock();
        try {
            boolean bl = this.serviceStatus == SCMService.ServiceStatus.RUNNING && this.clock.millis() - this.lastTimeToBeReadyInMillis >= this.waitTimeInMillis;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @VisibleForTesting
    public synchronized void runImmediately() {
        this.runImmediately = true;
        this.notify();
    }

    @VisibleForTesting
    public boolean getRunning() {
        return this.running.get();
    }

    public static class Builder {
        private long intervalInMillis;
        private long waitTimeInMillis;
        private String serviceName;
        private Runnable periodicalTask;
        private SCMContext scmContext;
        private Clock clock;

        public Builder setIntervalInMillis(long intervalInMillis) {
            this.intervalInMillis = intervalInMillis;
            return this;
        }

        public Builder setWaitTimeInMillis(long waitTimeInMillis) {
            this.waitTimeInMillis = waitTimeInMillis;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setScmContext(SCMContext scmContext) {
            this.scmContext = scmContext;
            return this;
        }

        public Builder setPeriodicalTask(Runnable periodicalTask) {
            this.periodicalTask = periodicalTask;
            return this;
        }

        public BackgroundSCMService build() {
            Preconditions.assertNotNull((Object)this.scmContext, (String)"scmContext is null");
            Preconditions.assertNotNull((Object)this.periodicalTask, (String)"periodicalTask is null");
            Preconditions.assertNotNull((Object)this.clock, (String)"clock is null");
            Preconditions.assertNotNull((Object)this.serviceName, (String)"serviceName is null");
            return new BackgroundSCMService(this);
        }
    }
}

