/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hdds.scm.ha.ReflectionUtil;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.StatefulServiceStateManager;

public abstract class StatefulService
implements SCMService {
    private final StatefulServiceStateManager stateManager;

    protected StatefulService(StatefulServiceStateManager stateManager) {
        this.stateManager = stateManager;
    }

    protected final void saveConfiguration(Message configurationMessage) throws IOException {
        this.stateManager.saveConfiguration(this.getServiceName(), configurationMessage.toByteString());
    }

    protected final <T extends Message> T readConfiguration(Class<T> configType) throws IOException {
        ByteString byteString = this.stateManager.readConfiguration(this.getServiceName());
        if (byteString == null) {
            return null;
        }
        try {
            return (T)((Message)configType.cast(ReflectionUtil.getMethod(configType, "parseFrom", ByteString.class).invoke(null, byteString)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IOException("Message cannot be parsed. Ensure that " + configType + " is the correct expected message type for " + this.getServiceName(), e);
        }
    }

    protected final void deleteConfiguration() throws IOException {
        this.stateManager.deleteConfiguration(this.getServiceName());
    }
}

