/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.container.common.utils.RawDB;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatanodeStoreCache {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeStoreCache.class);
    private final Map<String, RawDB> datanodeStoreMap = new ConcurrentHashMap<String, RawDB>();
    private static DatanodeStoreCache cache;
    private boolean miniClusterMode;

    private DatanodeStoreCache() {
    }

    public static synchronized DatanodeStoreCache getInstance() {
        if (cache == null) {
            cache = new DatanodeStoreCache();
        }
        return cache;
    }

    @VisibleForTesting
    public static synchronized void setMiniClusterMode() {
        DatanodeStoreCache.getInstance().miniClusterMode = true;
    }

    @VisibleForTesting
    public static synchronized void setMiniClusterMode(boolean isMiniCluster) {
        DatanodeStoreCache.getInstance().miniClusterMode = isMiniCluster;
    }

    public void addDB(String containerDBPath, RawDB db) {
        this.datanodeStoreMap.putIfAbsent(containerDBPath, db);
        LOG.info("Added db {} to cache", (Object)containerDBPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawDB getDB(String containerDBPath, ConfigurationSource conf) throws IOException {
        RawDB db = this.datanodeStoreMap.get(containerDBPath);
        if (db == null) {
            DatanodeStoreCache datanodeStoreCache = this;
            synchronized (datanodeStoreCache) {
                db = this.datanodeStoreMap.get(containerDBPath);
                if (db == null) {
                    try {
                        DatanodeStoreSchemaThreeImpl store = new DatanodeStoreSchemaThreeImpl(conf, containerDBPath, false);
                        db = new RawDB(store, containerDBPath);
                        this.datanodeStoreMap.put(containerDBPath, db);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to get DB store {}", (Object)containerDBPath, (Object)e);
                        throw new IOException("Failed to get DB store " + containerDBPath, e);
                    }
                }
            }
        }
        return db;
    }

    public void removeDB(String containerDBPath) {
        RawDB db = this.datanodeStoreMap.remove(containerDBPath);
        if (db == null) {
            LOG.debug("DB {} already removed", (Object)containerDBPath);
            return;
        }
        db.getStore().stop();
        LOG.info("Removed db {} from cache", (Object)containerDBPath);
    }

    public void shutdownCache() {
        if (this.miniClusterMode) {
            if (!this.datanodeStoreMap.isEmpty()) {
                LOG.info("Skip clearing cache in mini cluster mode. Entries left: {}", new TreeSet<String>(this.datanodeStoreMap.keySet()));
            }
            return;
        }
        for (RawDB db : this.datanodeStoreMap.values()) {
            db.getStore().stop();
        }
        this.datanodeStoreMap.clear();
    }

    public int size() {
        return this.datanodeStoreMap.size();
    }
}

