/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;

public abstract class StorageVolumeFactory {
    private ConfigurationSource conf;
    private SpaceUsageCheckFactory usageCheckFactory;
    private MutableVolumeSet volumeSet;
    private String datanodeUuid;
    private String clusterID;

    public StorageVolumeFactory(ConfigurationSource conf, SpaceUsageCheckFactory usageCheckFactory, MutableVolumeSet volumeSet, String datanodeUuid, String clusterID) {
        this.conf = conf;
        this.usageCheckFactory = usageCheckFactory;
        this.volumeSet = volumeSet;
        this.datanodeUuid = datanodeUuid;
        this.clusterID = clusterID;
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    public SpaceUsageCheckFactory getUsageCheckFactory() {
        return this.usageCheckFactory;
    }

    public VolumeSet getVolumeSet() {
        return this.volumeSet;
    }

    public String getDatanodeUuid() {
        return this.datanodeUuid;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    protected void checkAndSetClusterID(String idFromVersionFile) throws InconsistentStorageStateException {
        if (this.clusterID == null) {
            this.clusterID = idFromVersionFile;
            return;
        }
        if (!idFromVersionFile.equals(this.clusterID)) {
            throw new InconsistentStorageStateException("Mismatched ClusterIDs. VolumeSet has: " + this.clusterID + ", and version file has: " + idFromVersionFile);
        }
    }

    abstract StorageVolume createVolume(String var1, StorageType var2) throws IOException;

    abstract StorageVolume createFailedVolume(String var1) throws IOException;
}

