/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.IOException;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.metadata.DBStoreManager;

public interface DatanodeStore
extends DBStoreManager {
    public static final String NO_SUCH_BLOCK_ERR_MSG = "Unable to find the block.";

    public Table<String, BlockData> getBlockDataTable();

    public Table<String, Long> getMetadataTable();

    public Table<String, ChunkInfoList> getDeletedBlocksTable();

    public Table<String, Long> getFinalizeBlocksTable();

    public Table<String, BlockData> getLastChunkInfoTable();

    public BlockIterator<BlockData> getBlockIterator(long var1) throws IOException;

    public BlockIterator<BlockData> getBlockIterator(long var1, MetadataKeyFilters.KeyPrefixFilter var3) throws IOException;

    public BlockIterator<Long> getFinalizeBlockIterator(long var1, MetadataKeyFilters.KeyPrefixFilter var3) throws IOException;

    default public BlockData getBlockByID(BlockID blockID, String blockKey) throws IOException {
        BlockData blockData = (BlockData)this.getBlockDataTable().get((Object)blockKey);
        return this.getCompleteBlockData(blockData, blockID, blockKey);
    }

    default public BlockData getCompleteBlockData(BlockData blockData, BlockID blockID, String blockKey) throws IOException {
        if (blockData == null) {
            throw new StorageContainerException("Unable to find the block. BlockID : " + blockID, ContainerProtos.Result.NO_SUCH_BLOCK);
        }
        return blockData;
    }

    default public void putBlockByID(BatchOperation batch, boolean incremental, long localID, BlockData data, KeyValueContainerData containerData, boolean endOfBlock) throws IOException {
        this.getBlockDataTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)data);
    }
}

