/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.File;
import java.util.List;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;

public class DatanodeTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private final Table<KEY, VALUE> table;

    public DatanodeTable(Table<KEY, VALUE> table) {
        this.table = table;
    }

    public void put(KEY key, VALUE value) throws RocksDatabaseException, CodecException {
        this.table.put(key, value);
    }

    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws RocksDatabaseException, CodecException {
        this.table.putWithBatch(batch, key, value);
    }

    public boolean isEmpty() throws RocksDatabaseException {
        return this.table.isEmpty();
    }

    public void delete(KEY key) throws RocksDatabaseException, CodecException {
        this.table.delete(key);
    }

    public void deleteRange(KEY beginKey, KEY endKey) throws RocksDatabaseException, CodecException {
        this.table.deleteRange(beginKey, endKey);
    }

    public void deleteWithBatch(BatchOperation batch, KEY key) throws CodecException {
        this.table.deleteWithBatch(batch, key);
    }

    public void deleteRangeWithBatch(BatchOperation batch, KEY beginKey, KEY endKey) throws CodecException {
        this.table.deleteRangeWithBatch(batch, beginKey, endKey);
    }

    public final Table.KeyValueIterator<KEY, VALUE> iterator(KEY prefix, Table.KeyValueIterator.Type type) {
        throw new UnsupportedOperationException("Iterating tables directly is not supported for datanode containers due to differing schema version.");
    }

    public String getName() {
        return this.table.getName();
    }

    public long getEstimatedKeyCount() throws RocksDatabaseException {
        return this.table.getEstimatedKeyCount();
    }

    public boolean isExist(KEY key) throws RocksDatabaseException, CodecException {
        return this.table.isExist(key);
    }

    public VALUE get(KEY key) throws RocksDatabaseException, CodecException {
        return (VALUE)this.table.get(key);
    }

    public VALUE getIfExist(KEY key) throws RocksDatabaseException, CodecException {
        return (VALUE)this.table.getIfExist(key);
    }

    public VALUE getReadCopy(KEY key) throws RocksDatabaseException, CodecException {
        return (VALUE)this.table.getReadCopy(key);
    }

    public List<Table.KeyValue<KEY, VALUE>> getRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.KeyPrefixFilter filter, boolean isSequential) throws RocksDatabaseException, CodecException {
        return this.table.getRangeKVs(startKey, count, prefix, filter, isSequential);
    }

    public void deleteBatchWithPrefix(BatchOperation batch, KEY prefix) throws RocksDatabaseException, CodecException {
        this.table.deleteBatchWithPrefix(batch, prefix);
    }

    public void dumpToFileWithPrefix(File externalFile, KEY prefix) throws RocksDatabaseException, CodecException {
        this.table.dumpToFileWithPrefix(externalFile, prefix);
    }

    public void loadFromFile(File externalFile) throws RocksDatabaseException {
        this.table.loadFromFile(externalFile);
    }
}

