/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.ozone.container.common.interfaces.ScanResult;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScanError;

public class MetadataScanResult
implements ScanResult {
    private final List<ContainerScanError> errors;
    private final boolean deleted;
    private static final MetadataScanResult HEALTHY_RESULT = new MetadataScanResult(Collections.emptyList(), false);
    private static final MetadataScanResult DELETED = new MetadataScanResult(Collections.emptyList(), true);

    protected MetadataScanResult(List<ContainerScanError> errors, boolean deleted) {
        this.errors = errors;
        this.deleted = deleted;
    }

    public static MetadataScanResult fromErrors(List<ContainerScanError> errors) {
        if (errors.isEmpty()) {
            return HEALTHY_RESULT;
        }
        return new MetadataScanResult(errors, false);
    }

    public static MetadataScanResult deleted() {
        return DELETED;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<ContainerScanError> getErrors() {
        return this.errors;
    }

    public String toString() {
        if (this.deleted) {
            return "Container was deleted";
        }
        if (this.errors.isEmpty()) {
            return "Container has 0 errors";
        }
        if (this.errors.size() == 1) {
            return "Container has 1 error: " + this.errors.get(0);
        }
        return "Container has " + this.errors.size() + " errors. The first error is: " + this.errors.get(0);
    }
}

