/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.container.checksum.ContainerChecksumTreeManager;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.BlockDeletingService;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.report.IncrementalReportSender;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerGrpc;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.utils.ContainerInspectorUtil;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.StorageVolumeChecker;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.StaleRecoveringContainerScrubbingService;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStore;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStoreImpl;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractBackgroundContainerScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.BackgroundContainerDataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.BackgroundContainerMetadataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScannerConfiguration;
import org.apache.hadoop.ozone.container.ozoneimpl.OnDemandContainerScanner;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.ReplicationServer;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneContainer.class);
    private final HddsDispatcher hddsDispatcher;
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private final ConfigurationSource config;
    private final MutableVolumeSet volumeSet;
    private final MutableVolumeSet metaVolumeSet;
    private final MutableVolumeSet dbVolumeSet;
    private final StorageVolumeChecker volumeChecker;
    private final ContainerSet containerSet;
    private final XceiverServerSpi writeChannel;
    private final XceiverServerSpi readChannel;
    private final ContainerController controller;
    private BackgroundContainerMetadataScanner metadataScanner;
    private OnDemandContainerScanner onDemandScanner;
    private List<BackgroundContainerDataScanner> dataScanners;
    private List<AbstractBackgroundContainerScanner> backgroundScanners;
    private final BlockDeletingService blockDeletingService;
    private final StaleRecoveringContainerScrubbingService recoveringContainerScrubbingService;
    private final GrpcTlsConfig tlsClientConfig;
    private final AtomicReference<InitializingStatus> initializingStatus;
    private final ReplicationServer replicationServer;
    private DatanodeDetails datanodeDetails;
    private StateContext context;
    private final ContainerChecksumTreeManager checksumTreeManager;
    private ScheduledExecutorService dbCompactionExecutorService;
    private final ContainerMetrics metrics;
    private WitnessedContainerMetadataStore witnessedContainerMetadataStore;

    public OzoneContainer(HddsDatanodeService hddsDatanodeService, DatanodeDetails datanodeDetails, ConfigurationSource conf, StateContext context, CertificateClient certClient, SecretKeyVerifierClient secretKeyClient, VolumeChoosingPolicy volumeChoosingPolicy) throws IOException {
        this.config = conf;
        this.datanodeDetails = datanodeDetails;
        this.context = context;
        this.volumeChecker = new StorageVolumeChecker(conf, new Timer(), datanodeDetails.threadNamePrefix());
        this.volumeSet = new MutableVolumeSet(datanodeDetails.getUuidString(), conf, context, StorageVolume.VolumeType.DATA_VOLUME, this.volumeChecker);
        this.volumeSet.setFailedVolumeListener((CheckedRunnable<IOException>)((CheckedRunnable)this::handleVolumeFailures));
        this.metaVolumeSet = new MutableVolumeSet(datanodeDetails.getUuidString(), conf, context, StorageVolume.VolumeType.META_VOLUME, this.volumeChecker);
        this.dbVolumeSet = HddsServerUtil.getDatanodeDbDirs((ConfigurationSource)conf).isEmpty() ? null : new MutableVolumeSet(datanodeDetails.getUuidString(), conf, context, StorageVolume.VolumeType.DB_VOLUME, this.volumeChecker);
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)conf.getObject(DatanodeConfiguration.class));
        if (VersionedDatanodeFeatures.SchemaV3.isFinalizedAndEnabled(this.config)) {
            HddsVolumeUtil.loadAllHddsVolumeDbStore(this.volumeSet, this.dbVolumeSet, false, LOG);
            if (dnConf.autoCompactionSmallSstFile()) {
                this.dbCompactionExecutorService = Executors.newScheduledThreadPool(dnConf.getAutoCompactionSmallSstFileThreads(), new ThreadFactoryBuilder().setNameFormat(datanodeDetails.threadNamePrefix() + "RocksDBCompactionThread-%d").build());
                this.dbCompactionExecutorService.scheduleWithFixedDelay(this::compactDb, dnConf.getAutoCompactionSmallSstFileIntervalMinutes(), dnConf.getAutoCompactionSmallSstFileIntervalMinutes(), TimeUnit.MINUTES);
            }
        }
        long recoveringContainerTimeout = this.config.getTimeDuration("ozone.recovering.container.timeout", "20m", TimeUnit.MILLISECONDS);
        this.witnessedContainerMetadataStore = WitnessedContainerMetadataStoreImpl.get(conf);
        this.containerSet = ContainerSet.newRwContainerSet(this.witnessedContainerMetadataStore, recoveringContainerTimeout);
        this.volumeSet.setGatherContainerUsages(this::gatherContainerUsages);
        this.metadataScanner = null;
        this.metrics = ContainerMetrics.create(conf);
        this.handlers = Maps.newHashMap();
        IncrementalReportSender<Container> icrSender = this.createIncrementalReportSender();
        this.checksumTreeManager = new ContainerChecksumTreeManager(this.config);
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            this.handlers.put(containerType, Handler.getHandlerForContainerType(containerType, conf, context.getParent().getDatanodeDetails().getUuidString(), this.containerSet, this.volumeSet, volumeChoosingPolicy, this.metrics, icrSender, this.checksumTreeManager));
        }
        SecurityConfig secConf = new SecurityConfig(conf);
        this.hddsDispatcher = new HddsDispatcher(this.config, this.containerSet, this.volumeSet, this.handlers, context, this.metrics, TokenVerifier.create((SecurityConfig)secConf, (SecretKeyVerifierClient)secretKeyClient));
        this.controller = new ContainerController(this.containerSet, this.handlers);
        this.writeChannel = XceiverServerRatis.newXceiverServerRatis(hddsDatanodeService, datanodeDetails, this.config, this.hddsDispatcher, this.controller, certClient, context);
        this.replicationServer = new ReplicationServer(this.controller, (ReplicationServer.ReplicationConfig)conf.getObject(ReplicationServer.ReplicationConfig.class), secConf, certClient, new ContainerImporter(conf, this.containerSet, this.controller, this.volumeSet, volumeChoosingPolicy), datanodeDetails.threadNamePrefix());
        this.readChannel = new XceiverServerGrpc(datanodeDetails, this.config, this.hddsDispatcher, certClient);
        Duration blockDeletingSvcInterval = dnConf.getBlockDeletionInterval();
        long blockDeletingServiceTimeout = this.config.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        int blockDeletingServiceWorkerSize = this.config.getInt("ozone.block.deleting.service.workers", 10);
        this.blockDeletingService = new BlockDeletingService(this, blockDeletingSvcInterval.toMillis(), blockDeletingServiceTimeout, TimeUnit.MILLISECONDS, blockDeletingServiceWorkerSize, this.config, datanodeDetails.threadNamePrefix(), this.checksumTreeManager, context.getParent().getReconfigurationHandler());
        Duration recoveringContainerScrubbingSvcInterval = dnConf.getRecoveringContainerScrubInterval();
        long recoveringContainerScrubbingServiceTimeout = this.config.getTimeDuration("ozone.recovering.container.scrubbing.service.timeout", "300s", TimeUnit.MILLISECONDS);
        int recoveringContainerScrubbingServiceWorkerSize = this.config.getInt("ozone.recovering.container.scrubbing.service.workers", 10);
        this.recoveringContainerScrubbingService = new StaleRecoveringContainerScrubbingService(recoveringContainerScrubbingSvcInterval.toMillis(), TimeUnit.MILLISECONDS, recoveringContainerScrubbingServiceWorkerSize, recoveringContainerScrubbingServiceTimeout, this.containerSet);
        this.tlsClientConfig = certClient != null && secConf.isGrpcTlsEnabled() ? new GrpcTlsConfig((KeyManager)certClient.getKeyManager(), (TrustManager)certClient.getTrustManager(), true) : null;
        this.initializingStatus = new AtomicReference<InitializingStatus>(InitializingStatus.UNINITIALIZED);
    }

    @VisibleForTesting
    public OzoneContainer(DatanodeDetails datanodeDetails, ConfigurationSource conf, StateContext context, VolumeChoosingPolicy volumeChoosingPolicy) throws IOException {
        this(null, datanodeDetails, conf, context, null, null, volumeChoosingPolicy);
    }

    public GrpcTlsConfig getTlsClientConfig() {
        return this.tlsClientConfig;
    }

    @VisibleForTesting
    public void buildContainerSet() throws IOException {
        Iterator<StorageVolume> volumeSetIterator = this.volumeSet.getVolumesList().iterator();
        ArrayList<Thread> volumeThreads = new ArrayList<Thread>();
        long startTime = Time.monotonicNow();
        ContainerInspectorUtil.load();
        String threadNamePrefix = this.datanodeDetails.threadNamePrefix();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "ContainerReader-%d").build();
        while (volumeSetIterator.hasNext()) {
            StorageVolume volume = volumeSetIterator.next();
            ContainerReader containerReader = new ContainerReader(this.volumeSet, (HddsVolume)volume, this.containerSet, this.config, true);
            Thread thread = threadFactory.newThread(containerReader);
            thread.start();
            volumeThreads.add(thread);
        }
        try {
            for (Thread volumeThread : volumeThreads) {
                volumeThread.join();
            }
            try (TableIterator itr = this.getWitnessedContainerMetadataStore().getContainerCreateInfoTable().keyIterator();){
                HashMap<ContainerID, Long> containerIds = new HashMap<ContainerID, Long>();
                while (itr.hasNext()) {
                    containerIds.put((ContainerID)itr.next(), 0L);
                }
                this.containerSet.buildMissingContainerSetAndValidate(containerIds, ContainerID::getId);
            }
        }
        catch (InterruptedException ex) {
            LOG.error("Volume Threads Interrupted exception", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        ContainerInspectorUtil.unload();
        LOG.info("Build ContainerSet costs {}s", (Object)((Time.monotonicNow() - startTime) / 1000L));
    }

    private IncrementalReportSender<Container> createIncrementalReportSender() {
        return new IncrementalReportSender<Container>(){

            private void sendICR(Container container, boolean immediate) throws StorageContainerException {
                StorageContainerDatanodeProtocolProtos.ContainerReplicaProto containerReport = container.getContainerReport();
                StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto icr = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder().addReport(containerReport).build();
                OzoneContainer.this.context.addIncrementalReport((Message)icr);
                if (immediate) {
                    OzoneContainer.this.context.getParent().triggerHeartbeat();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void send(Container container) throws StorageContainerException {
                ContainerSet containerSet = OzoneContainer.this.containerSet;
                synchronized (containerSet) {
                    this.sendICR(container, true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDeferred(Container container) throws StorageContainerException {
                ContainerSet containerSet = OzoneContainer.this.containerSet;
                synchronized (containerSet) {
                    this.sendICR(container, false);
                }
            }
        };
    }

    private void startContainerScrub() {
        ContainerScannerConfiguration c = (ContainerScannerConfiguration)this.config.getObject(ContainerScannerConfiguration.class);
        if (!c.isEnabled()) {
            LOG.info("Scheduled background container scanners and the on-demand container scanner have been disabled.");
            return;
        }
        this.backgroundScanners = new LinkedList<AbstractBackgroundContainerScanner>();
        if (c.isMetadataScanEnabled()) {
            this.initMetadataScanner(c);
        }
        if (c.isDataScanEnabled()) {
            this.initContainerScanner(c);
            this.initOnDemandContainerScanner(c);
        }
    }

    private void initContainerScanner(ContainerScannerConfiguration c) {
        if (c.getBandwidthPerVolume() == 0L) {
            LOG.warn("hdds.container.scrub.volume.bytes.per.second is set to 0, so background container data scanner will not start.");
            return;
        }
        this.dataScanners = new ArrayList<BackgroundContainerDataScanner>();
        for (StorageVolume v : this.volumeSet.getVolumesList()) {
            BackgroundContainerDataScanner s = new BackgroundContainerDataScanner(c, this.controller, (HddsVolume)v);
            s.start();
            this.dataScanners.add(s);
            this.backgroundScanners.add(s);
        }
    }

    private void initHddsVolumeContainer() {
        for (StorageVolume v : this.volumeSet.getVolumesList()) {
            HddsVolume hddsVolume = (HddsVolume)v;
            hddsVolume.setController(this.controller);
        }
    }

    private void initMetadataScanner(ContainerScannerConfiguration c) {
        if (this.metadataScanner == null) {
            this.metadataScanner = new BackgroundContainerMetadataScanner(c, this.controller);
            this.backgroundScanners.add(this.metadataScanner);
        }
        this.metadataScanner.start();
    }

    private void initOnDemandContainerScanner(ContainerScannerConfiguration c) {
        if (c.getOnDemandBandwidthPerVolume() == 0L) {
            LOG.warn("hdds.container.scrub.on.demand.volume.bytes.per.second is set to 0, so the on-demand container data scanner will not start.");
            return;
        }
        this.onDemandScanner = new OnDemandContainerScanner(c, this.controller);
        this.containerSet.registerOnDemandScanner(this.onDemandScanner);
    }

    private void stopContainerScrub() {
        if (this.metadataScanner == null) {
            return;
        }
        this.metadataScanner.shutdown();
        this.metadataScanner = null;
        if (this.dataScanners == null) {
            return;
        }
        for (BackgroundContainerDataScanner s : this.dataScanners) {
            s.shutdown();
        }
        this.onDemandScanner.shutdown();
    }

    @VisibleForTesting
    public void pauseContainerScrub() {
        this.backgroundScanners.forEach(AbstractBackgroundContainerScanner::pause);
    }

    @VisibleForTesting
    public void resumeContainerScrub() {
        this.backgroundScanners.forEach(AbstractBackgroundContainerScanner::unpause);
    }

    @VisibleForTesting
    public OnDemandContainerScanner getOnDemandScanner() {
        return this.onDemandScanner;
    }

    public void start(String clusterId) throws IOException {
        if (!this.initializingStatus.compareAndSet(InitializingStatus.UNINITIALIZED, InitializingStatus.INITIALIZING)) {
            while (this.initializingStatus.get() != InitializingStatus.INITIALIZED) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("Ignore. OzoneContainer already started.");
            return;
        }
        DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage(this.config);
        layoutStorage.setClusterId(clusterId);
        layoutStorage.persistCurrentState();
        this.buildContainerSet();
        this.volumeChecker.start();
        this.volumeSet.checkAllVolumes();
        this.volumeSet.startAllVolume();
        this.metaVolumeSet.checkAllVolumes();
        this.metaVolumeSet.startAllVolume();
        if (this.dbVolumeSet != null) {
            this.dbVolumeSet.checkAllVolumes();
            this.dbVolumeSet.startAllVolume();
        }
        LOG.info("Attempting to start container services.");
        this.startContainerScrub();
        this.replicationServer.start();
        this.datanodeDetails.setPort(DatanodeDetails.Port.Name.REPLICATION, this.replicationServer.getPort());
        this.hddsDispatcher.init();
        this.hddsDispatcher.setClusterId(clusterId);
        this.writeChannel.start();
        this.readChannel.start();
        this.blockDeletingService.start();
        this.recoveringContainerScrubbingService.start();
        this.initHddsVolumeContainer();
        this.initializingStatus.set(InitializingStatus.INITIALIZED);
    }

    public void stop() {
        LOG.info("Attempting to stop container services.");
        this.stopContainerScrub();
        this.replicationServer.stop();
        this.writeChannel.stop();
        this.readChannel.stop();
        this.handlers.values().forEach(Handler::stop);
        this.hddsDispatcher.shutdown();
        this.volumeChecker.shutdownAndWait(0, TimeUnit.SECONDS);
        this.volumeSet.shutdown();
        this.metaVolumeSet.shutdown();
        if (this.dbVolumeSet != null) {
            this.dbVolumeSet.shutdown();
        }
        if (this.dbCompactionExecutorService != null) {
            this.dbCompactionExecutorService.shutdown();
        }
        this.blockDeletingService.shutdown();
        this.recoveringContainerScrubbingService.shutdown();
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.metrics});
        ContainerMetrics.remove();
        this.checksumTreeManager.stop();
        if (this.witnessedContainerMetadataStore != null) {
            try {
                this.witnessedContainerMetadataStore.stop();
            }
            catch (Exception e) {
                LOG.error("Error while stopping witnessedContainerMetadataStore. Status of store: {}", (Object)this.witnessedContainerMetadataStore.isClosed(), (Object)e);
            }
            this.witnessedContainerMetadataStore = null;
        }
    }

    public void handleVolumeFailures() throws StorageContainerException {
        if (this.containerSet != null) {
            this.containerSet.handleVolumeFailures(this.context);
        }
    }

    @VisibleForTesting
    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public Long gatherContainerUsages(HddsVolume storageVolume) {
        AtomicLong usages = new AtomicLong();
        this.containerSet.getContainerMapIterator().forEachRemaining(e -> {
            if (((ContainerData)((Container)e.getValue()).getContainerData()).getVolume().getStorageID().equals(storageVolume.getStorageID())) {
                usages.addAndGet(((ContainerData)((Container)e.getValue()).getContainerData()).getBytesUsed());
            }
        });
        return usages.get();
    }

    public StorageContainerDatanodeProtocolProtos.PipelineReportsProto getPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder pipelineReportsProto = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        pipelineReportsProto.addAllPipelineReport(this.writeChannel.getPipelineReport());
        return pipelineReportsProto.build();
    }

    public XceiverServerSpi getWriteChannel() {
        return this.writeChannel;
    }

    public XceiverServerSpi getReadChannel() {
        return this.readChannel;
    }

    public ContainerController getController() {
        return this.controller;
    }

    public StorageContainerDatanodeProtocolProtos.NodeReportProto getNodeReport() throws IOException {
        StorageLocationReport[] metaReports;
        StorageLocationReport[] reports = this.volumeSet.getStorageReport();
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nrb = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        for (StorageLocationReport report : reports) {
            nrb.addStorageReport(report.getProtoBufMessage());
        }
        for (StorageLocationReport metaReport : metaReports = this.metaVolumeSet.getStorageReport()) {
            nrb.addMetadataStorageReport(metaReport.getMetadataProtoBufMessage());
        }
        if (this.dbVolumeSet != null) {
            StorageLocationReport[] dbReports;
            for (StorageLocationReport dbReport : dbReports = this.dbVolumeSet.getStorageReport()) {
                nrb.addDbStorageReport(dbReport.getProtoBufMessage());
            }
        }
        return nrb.build();
    }

    @VisibleForTesting
    public ContainerDispatcher getDispatcher() {
        return this.hddsDispatcher;
    }

    public MutableVolumeSet getVolumeSet() {
        return this.volumeSet;
    }

    public MutableVolumeSet getMetaVolumeSet() {
        return this.metaVolumeSet;
    }

    public MutableVolumeSet getDbVolumeSet() {
        return this.dbVolumeSet;
    }

    public ContainerMetrics getMetrics() {
        return this.metrics;
    }

    public BlockDeletingService getBlockDeletingService() {
        return this.blockDeletingService;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }

    public void compactDb() {
        for (StorageVolume volume : this.volumeSet.getVolumesList()) {
            HddsVolume hddsVolume = (HddsVolume)volume;
            CompletableFuture.runAsync(hddsVolume::compactDb, this.dbCompactionExecutorService);
        }
    }

    public WitnessedContainerMetadataStore getWitnessedContainerMetadataStore() {
        return this.witnessedContainerMetadataStore;
    }

    static enum InitializingStatus {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

