/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.fs.DU;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DUOptimized
implements SpaceUsageSource {
    private static final Logger LOG = LoggerFactory.getLogger(DUOptimized.class);
    private final DU metaPathDU;
    private Supplier<Supplier<Long>> containerUsedSpaceProvider;

    public DUOptimized(File path, Supplier<File> exclusionProvider) {
        this.metaPathDU = new DU(exclusionProvider, path);
    }

    public long getUsedSpace() {
        long metaPathSize = this.metaPathDU.getUsedSpace();
        if (null == this.containerUsedSpaceProvider) {
            return metaPathSize;
        }
        Supplier<Long> gatherContainerUsages = this.containerUsedSpaceProvider.get();
        long containerUsedSpace = gatherContainerUsages.get();
        LOG.info("Disk metaPath du usages {}, container data usages {}", (Object)metaPathSize, (Object)containerUsedSpace);
        return metaPathSize + containerUsedSpace;
    }

    public long getCapacity() {
        return this.metaPathDU.getCapacity();
    }

    public long getAvailable() {
        return this.metaPathDU.getAvailable();
    }

    public void setContainerUsedSpaceProvider(Supplier<Supplier<Long>> containerUsedSpaceProvider) {
        this.containerUsedSpaceProvider = containerUsedSpaceProvider;
    }
}

