/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.OzoneSecretKey;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.OzoneSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateNotification;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class OzoneSecretManager<T extends TokenIdentifier>
extends SecretManager<T>
implements CertificateNotification {
    private final Logger logger;
    private final SecurityConfig securityConfig;
    private final long tokenMaxLifetime;
    private final long tokenRenewInterval;
    private final Text service;
    private CertificateClient certClient;
    private volatile boolean running;
    private AtomicReference<OzoneSecretKey> currentKey;
    private AtomicInteger currentKeyId;
    private AtomicInteger tokenSequenceNumber;

    public OzoneSecretManager(SecurityConfig secureConf, long tokenMaxLifetime, long tokenRenewInterval, Text service, Logger logger) {
        this.securityConfig = secureConf;
        this.tokenMaxLifetime = tokenMaxLifetime;
        this.tokenRenewInterval = tokenRenewInterval;
        this.currentKeyId = new AtomicInteger();
        this.tokenSequenceNumber = new AtomicInteger();
        this.service = service;
        this.logger = logger;
        this.currentKey = new AtomicReference();
    }

    public byte[] createPassword(byte[] identifier, PrivateKey privateKey) throws OzoneSecurityException {
        try {
            Signature rsaSignature = Signature.getInstance(this.getDefaultSignatureAlgorithm());
            rsaSignature.initSign(privateKey);
            rsaSignature.update(identifier);
            return rsaSignature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new OzoneSecurityException("Error while creating HMAC hash for token.", (Throwable)ex, OzoneSecurityException.ResultCodes.SECRET_MANAGER_HMAC_ERROR);
        }
    }

    public byte[] createPassword(T identifier) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating password for identifier: {}, currentKey: {}", (Object)this.formatTokenId(identifier), (Object)this.currentKey.get().getKeyId());
        }
        byte[] password = null;
        try {
            password = this.createPassword(identifier.getBytes(), this.currentKey.get().getPrivateKey());
        }
        catch (IOException ioe) {
            this.logger.error("Could not store token {}!!", (Object)this.formatTokenId(identifier), (Object)ioe);
        }
        return password;
    }

    public abstract long renewToken(Token<T> var1, String var2) throws IOException;

    public abstract T cancelToken(Token<T> var1, String var2) throws IOException;

    public int incrementCurrentKeyId() {
        return this.currentKeyId.incrementAndGet();
    }

    public int getDelegationTokenSeqNum() {
        return this.tokenSequenceNumber.get();
    }

    public void setDelegationTokenSeqNum(int seqNum) {
        this.tokenSequenceNumber.set(seqNum);
    }

    public int incrementDelegationTokenSeqNum() {
        return this.tokenSequenceNumber.incrementAndGet();
    }

    private OzoneSecretKey updateCurrentKey(KeyPair keyPair, X509Certificate certificate) {
        int newCurrentId = this.incrementCurrentKeyId();
        OzoneSecretKey newKey = new OzoneSecretKey(newCurrentId, certificate.getNotAfter().getTime(), keyPair, certificate.getSerialNumber().toString());
        this.currentKey.set(newKey);
        this.logger.info("Updated current master key for generating tokens. Cert id {}, Master key id {}", (Object)certificate.getSerialNumber().toString(), (Object)newKey.getKeyId());
        return newKey;
    }

    public void notifyCertificateRenewed(CertificateClient client, String oldCertId, String newCertId) {
        if (!oldCertId.equals(this.getCertSerialId())) {
            this.logger.info("Old certificate Id doesn't match. Holding {}, oldCertId {}", (Object)this.getCertSerialId(), (Object)oldCertId);
        }
        if (!newCertId.equals(this.certClient.getCertificate().getSerialNumber().toString())) {
            this.logger.info("New certificate Id doesn't match. Holding in caClient {}, newCertId {}", (Object)newCertId, (Object)this.certClient.getCertificate().getSerialNumber().toString());
        }
        this.logger.info("Certificate is changed from {} to {}", (Object)oldCertId, (Object)newCertId);
        this.updateCurrentKey(new KeyPair(this.certClient.getPublicKey(), this.certClient.getPrivateKey()), this.certClient.getCertificate());
    }

    public String formatTokenId(T id) {
        return "(" + id + ")";
    }

    public synchronized void start(CertificateClient client) throws IOException {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0);
        this.setCertClient(client);
        this.updateCurrentKey(new KeyPair(this.certClient.getPublicKey(), this.certClient.getPrivateKey()), this.certClient.getCertificate());
        client.registerNotificationReceiver((CertificateNotification)this);
        this.setIsRunning(true);
    }

    public synchronized void stop() throws IOException {
        this.setIsRunning(false);
    }

    public String getDefaultSignatureAlgorithm() {
        return this.securityConfig.getSignatureAlgo();
    }

    public long getTokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long getTokenRenewInterval() {
        return this.tokenRenewInterval;
    }

    public Text getService() {
        return this.service;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setIsRunning(boolean val) {
        this.running = val;
    }

    public OzoneSecretKey getCurrentKey() {
        return this.currentKey.get();
    }

    public AtomicInteger getCurrentKeyId() {
        return this.currentKeyId;
    }

    public String getCertSerialId() {
        return this.currentKey.get().getCertSerialId();
    }

    public AtomicInteger getTokenSequenceNumber() {
        return this.tokenSequenceNumber;
    }

    public CertificateClient getCertClient() {
        return this.certClient;
    }

    public void setCertClient(CertificateClient client) {
        this.certClient = client;
    }
}

