/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventExecutorMetrics;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadExecutor<P>
implements EventExecutor<P> {
    private static final String EVENT_QUEUE = "EventQueue";
    private static final Logger LOG = LoggerFactory.getLogger(SingleThreadExecutor.class);
    private final String name;
    private final ExecutorService executor;
    private final EventExecutorMetrics metrics;

    public SingleThreadExecutor(String name, String threadNamePrefix) {
        this.name = name;
        this.metrics = new EventExecutorMetrics(EVENT_QUEUE + name, "Event Executor metrics");
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(threadNamePrefix + EVENT_QUEUE + "-" + name);
            return thread;
        });
    }

    @Override
    public void onMessage(EventHandler<P> handler, P message, EventPublisher publisher) {
        this.metrics.incrementQueued();
        this.executor.execute(() -> {
            this.metrics.incrementScheduled();
            try {
                handler.onMessage(message, publisher);
                this.metrics.incrementDone();
            }
            catch (Exception ex) {
                LOG.error("Error on execution message {}", message, (Object)ex);
                this.metrics.incrementFailed();
            }
        });
    }

    @Override
    public long failedEvents() {
        return this.metrics.getFailed();
    }

    @Override
    public long successfulEvents() {
        return this.metrics.getDone();
    }

    @Override
    public long queuedEvents() {
        return this.metrics.getQueued();
    }

    @Override
    public long scheduledEvents() {
        return this.metrics.getScheduled();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.metrics.unregister();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

