/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v8_0.category;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v7_0.category.ContainerDecorator;
import org.apache.qpid.server.management.plugin.controller.v7_0.category.LegacyCategoryController;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.UpgraderHelper;

public class LegacyCategoryController_v8_0
extends LegacyCategoryController {
    private static final Map<String, String> NEW_TO_OLD = UpgraderHelper.reverse((Map)UpgraderHelper.MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES);

    LegacyCategoryController_v8_0(LegacyManagementController legacyManagementController, String type, String parentCategory, String defaultType, Set<TypeController> typeControllersByCategory) {
        super(legacyManagementController, type, parentCategory, defaultType, typeControllersByCategory);
    }

    @Override
    protected LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        LegacyConfiguredObject_v8_0 converted = new LegacyConfiguredObject_v8_0(this.getManagementController(), object, this.getCategory());
        if ("VirtualHost".equals(this.getCategory()) || "Broker".equals(this.getCategory())) {
            return new ContainerDecorator(converted);
        }
        return converted;
    }

    @Override
    protected Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        Map<String, Object> nextVersionAttributes = attributes.containsKey("context") ? this.convertContextToNextVersion(attributes) : attributes;
        return super.convertAttributesToNextVersion(root, path, nextVersionAttributes);
    }

    private Map<String, Object> convertContextToNextVersion(Map<String, Object> attributes) {
        Object context = attributes.get("context");
        if (context instanceof Map) {
            Map oldContext = (Map)context;
            Map newContext = UpgraderHelper.renameContextVariables((Map)oldContext, (Map)UpgraderHelper.MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES);
            HashMap<String, Object> nextVersionAttributes = new HashMap<String, Object>(attributes);
            nextVersionAttributes.put("context", newContext);
            return nextVersionAttributes;
        }
        return attributes;
    }

    static class LegacyConfiguredObject_v8_0
    extends GenericLegacyConfiguredObject {
        private static final Map<String, String> ALLOW_DENY_TO_WHITE_BLACK_MAPPING = new HashMap<String, String>();
        private static final Map<String, String> WHITE_BLACK_TO_ALLOW_DENY_MAPPING;

        LegacyConfiguredObject_v8_0(LegacyManagementController managementController, LegacyConfiguredObject nextVersionLegacyConfiguredObject, String category) {
            super(managementController, nextVersionLegacyConfiguredObject, category);
        }

        @Override
        public Object getAttribute(String name) {
            if ("context".equals(name)) {
                return this.convertContextToModelVersion(super.getAttribute(name));
            }
            Object value = this.isPortOrAuthenticationPovider() && WHITE_BLACK_TO_ALLOW_DENY_MAPPING.containsKey(name) ? super.getAttribute(WHITE_BLACK_TO_ALLOW_DENY_MAPPING.getOrDefault(name, name)) : super.getAttribute(name);
            return value;
        }

        private boolean isPortOrAuthenticationPovider() {
            return "Port".equals(this.getCategory()) || "AuthenticationProvider".equals(this.getCategory());
        }

        @Override
        public Collection<String> getAttributeNames() {
            Collection<String> attributeNames = super.getAttributeNames();
            if (this.isPortOrAuthenticationPovider()) {
                return attributeNames.stream().map(i -> ALLOW_DENY_TO_WHITE_BLACK_MAPPING.getOrDefault(i, (String)i)).collect(Collectors.toList());
            }
            return attributeNames;
        }

        @Override
        public Object getActualAttribute(String name) {
            Object value = super.getActualAttribute(name);
            if ("context".equals(name)) {
                return this.convertContextToModelVersion(value);
            }
            return value;
        }

        @Override
        public String getContextValue(String contextKey) {
            String nextVersionName = UpgraderHelper.MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.getOrDefault(contextKey, contextKey);
            return super.getContextValue(nextVersionName);
        }

        private Object convertContextToModelVersion(Object value) {
            if (value instanceof Map) {
                return UpgraderHelper.renameContextVariables((Map)((Map)value), NEW_TO_OLD);
            }
            return null;
        }

        static {
            ALLOW_DENY_TO_WHITE_BLACK_MAPPING.put("tlsProtocolAllowList", "tlsProtocolWhiteList");
            ALLOW_DENY_TO_WHITE_BLACK_MAPPING.put("tlsProtocolDenyList", "tlsProtocolBlackList");
            ALLOW_DENY_TO_WHITE_BLACK_MAPPING.put("tlsCipherSuiteAllowList", "tlsCipherSuiteWhiteList");
            ALLOW_DENY_TO_WHITE_BLACK_MAPPING.put("tlsCipherSuiteDenyList", "tlsCipherSuiteBlackList");
            WHITE_BLACK_TO_ALLOW_DENY_MAPPING = UpgraderHelper.reverse(ALLOW_DENY_TO_WHITE_BLACK_MAPPING);
        }
    }
}

