/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ArrayTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.BinaryTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.BooleanConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ByteTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.CharTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DecimalConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DefaultDescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.DoubleTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.FloatTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.IntTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ListConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.LongTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.MapConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.NullTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ShortTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.SmallIntConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.SmallLongConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.SmallUIntConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.SmallULongConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.StringTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.SymbolTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.TimestampTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.UByteTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.UIntTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ULongTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.UShortTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.UUIDTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ZeroListConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ZeroUIntConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ZeroULongConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;

public class ValueHandler
implements DescribedTypeConstructorRegistry.Source {
    public static final byte DESCRIBED_TYPE = 0;
    private final DescribedTypeConstructorRegistry _describedTypeConstructorRegistry;
    private static final TypeConstructor[][] TYPE_CONSTRUCTORS = new TypeConstructor[][]{new TypeConstructor[0], new TypeConstructor[0], new TypeConstructor[0], new TypeConstructor[0], {NullTypeConstructor.getInstance(), BooleanConstructor.getTrueInstance(), BooleanConstructor.getFalseInstance(), ZeroUIntConstructor.getInstance(), ZeroULongConstructor.getInstance(), ZeroListConstructor.getInstance()}, {UByteTypeConstructor.getInstance(), ByteTypeConstructor.getInstance(), SmallUIntConstructor.getInstance(), SmallULongConstructor.getInstance(), SmallIntConstructor.getInstance(), SmallLongConstructor.getInstance(), BooleanConstructor.getByteInstance()}, {UShortTypeConstructor.getInstance(), ShortTypeConstructor.getInstance()}, {UIntTypeConstructor.getInstance(), IntTypeConstructor.getInstance(), FloatTypeConstructor.getInstance(), CharTypeConstructor.getInstance(), DecimalConstructor.getDecimal32Instance()}, {ULongTypeConstructor.getInstance(), LongTypeConstructor.getInstance(), DoubleTypeConstructor.getInstance(), TimestampTypeConstructor.getInstance(), DecimalConstructor.getDecimal64Instance()}, {null, null, null, null, DecimalConstructor.getDecimal128Instance(), null, null, null, UUIDTypeConstructor.getInstance()}, {BinaryTypeConstructor.getInstance(1), StringTypeConstructor.getInstance(1), null, SymbolTypeConstructor.getInstance(1)}, {BinaryTypeConstructor.getInstance(4), StringTypeConstructor.getInstance(4), null, SymbolTypeConstructor.getInstance(4)}, {ListConstructor.getInstance(1), MapConstructor.getInstance(1)}, {ListConstructor.getInstance(4), MapConstructor.getInstance(4)}, {ArrayTypeConstructor.getOneByteSizeTypeConstructor()}, {ArrayTypeConstructor.getFourByteSizeTypeConstructor()}};

    public ValueHandler(DescribedTypeConstructorRegistry registry) {
        this._describedTypeConstructorRegistry = registry;
    }

    public Object parse(QpidByteBuffer in) throws AmqpErrorException {
        TypeConstructor constructor = this.readConstructor(in);
        return constructor.construct(in, this);
    }

    public TypeConstructor readConstructor(QpidByteBuffer in) throws AmqpErrorException {
        TypeConstructor tc;
        if (!in.hasRemaining()) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data - expected type, no data remaining", new Object[0]);
        }
        byte formatCode = in.get();
        if (formatCode == 0) {
            int originalPositions = in.position() - 1;
            Object descriptor = this.parse(in);
            DescribedTypeConstructor describedTypeConstructor = this._describedTypeConstructorRegistry.getConstructor(descriptor);
            if (describedTypeConstructor == null) {
                describedTypeConstructor = new DefaultDescribedTypeConstructor(descriptor);
            }
            return describedTypeConstructor.construct(descriptor, in, originalPositions, this);
        }
        int subCategory = formatCode >> 4 & 0xF;
        int subtype = formatCode & 0xF;
        try {
            tc = TYPE_CONSTRUCTORS[subCategory][subtype];
        }
        catch (IndexOutOfBoundsException e) {
            tc = null;
        }
        if (tc == null) {
            throw new AmqpErrorException(ConnectionError.FRAMING_ERROR, "Unknown type format-code 0x%02x", formatCode);
        }
        return tc;
    }

    public String toString() {
        return "ValueHandler{, _describedTypeConstructorRegistry=" + String.valueOf(this._describedTypeConstructorRegistry) + "}";
    }

    @Override
    public DescribedTypeConstructorRegistry getDescribedTypeRegistry() {
        return this._describedTypeConstructorRegistry;
    }
}

