/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.upgrade.AbstractStoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;

public class UpgradeFrom8To9
extends AbstractStoreUpgrade {
    private static final String DEFAULT_VERSION = "6.1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performUpgrade(Environment environment, UpgradeInteractionHandler handler, ConfiguredObject<?> parent) {
        this.reportStarting(environment, 8);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        Transaction transaction = environment.beginTransaction(null, null);
        try {
            Database userPreferencesDb = environment.openDatabase(transaction, "USER_PREFERENCES", dbConfig);
            userPreferencesDb.close();
            try (Database userPreferencesVersionDb = environment.openDatabase(transaction, "USER_PREFERENCES_VERSION", dbConfig);){
                if (userPreferencesVersionDb.count() == 0L) {
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry value = new DatabaseEntry();
                    StringBinding.stringToEntry((String)DEFAULT_VERSION, (DatabaseEntry)key);
                    LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
                    OperationStatus status = userPreferencesVersionDb.put(transaction, key, value);
                    if (status != OperationStatus.SUCCESS) {
                        throw new StoreException("Error initialising user preference version: " + String.valueOf(status));
                    }
                }
            }
            transaction.commit();
            this.reportFinished(environment, 9);
        }
        catch (RuntimeException e) {
            try {
                if (transaction.isValid()) {
                    transaction.abort();
                }
            }
            finally {
                throw e;
            }
        }
    }
}

