/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;

public abstract class AbstractFunctionExpression<T, R>
extends AbstractExpressionNode<T, R> {
    protected final String _functionName;

    public AbstractFunctionExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        this._functionName = alias.substring(0, alias.indexOf(40)).toUpperCase(Locale.US);
    }

    public String getFunctionName() {
        return this._functionName;
    }

    protected <X, Y> Y evaluateChild(int index, X value, FunctionParameterTypePredicate<Y> typePredicate) {
        ExpressionNode child = this.getChild(index);
        Object result = child.apply(value);
        if (!typePredicate.test(result)) {
            throw QueryEvaluationException.invalidFunctionParameter(this._functionName, result);
        }
        return (Y)result;
    }

    public <X, Y> Y getRequiredParameter(int index, X value, Class<Y> type, String message) {
        ExpressionNode child = this.getChild(index);
        Object result = child.apply(value);
        if (result == null || !type.isAssignableFrom(result.getClass())) {
            throw QueryEvaluationException.of(message, this._functionName, index + 1);
        }
        return (Y)result;
    }

    public <X, Y> Optional<Y> getOptionalParameter(int index, X value, Class<Y> type, String message) {
        ExpressionNode child = this.getChild(index);
        if (child == null) {
            return Optional.empty();
        }
        Y result = this.getRequiredParameter(index, value, type, message);
        return Optional.of(result);
    }

    public <X, Y> Optional<Y> getOptionalConstantParameter(int index, Class<Y> type, String message) {
        ExpressionNode child = this.getChild(index);
        if (child == null) {
            return Optional.empty();
        }
        Object result = child.apply(null);
        if (result == null) {
            return Optional.empty();
        }
        if (!type.isAssignableFrom(result.getClass())) {
            throw QueryEvaluationException.of(message, this._functionName, index + 1);
        }
        return Optional.of(result);
    }
}

