/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.lang.management.ThreadInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.util.PerfDataRecorder;
import org.apache.ranger.plugin.util.RangerPerfTracerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPerfTracer {
    protected final Logger logger;
    protected final String tag;
    protected final String data;
    protected final ThreadInfo threadInfo;
    protected final long startTime;
    protected final long userStartTime;
    private static final String tagEndMarker = "(";

    public static Logger getPerfLogger(String name) {
        return LoggerFactory.getLogger((String)("org.apache.ranger.perf." + name));
    }

    public static Logger getPerfLogger(Class<?> cls) {
        return RangerPerfTracer.getPerfLogger(cls.getName());
    }

    public static boolean isPerfTraceEnabled(Logger logger) {
        return logger.isDebugEnabled();
    }

    public static RangerPerfTracer getPerfTracer(Logger logger, String tag) {
        String data = "";
        String realTag = "";
        if (tag != null) {
            int indexOfTagEndMarker = StringUtils.indexOf((CharSequence)tag, (CharSequence)tagEndMarker);
            if (indexOfTagEndMarker != -1) {
                realTag = StringUtils.substring((String)tag, (int)0, (int)indexOfTagEndMarker);
                if (!PerfDataRecorder.collectStatistics()) {
                    data = StringUtils.substring((String)tag, (int)indexOfTagEndMarker);
                }
            } else {
                realTag = tag;
            }
        }
        return RangerPerfTracerFactory.getPerfTracer(logger, realTag, data);
    }

    public static RangerPerfTracer getPerfTracer(Logger logger, String tag, String data) {
        return RangerPerfTracerFactory.getPerfTracer(logger, tag, data);
    }

    public static void log(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.log();
        }
    }

    public static void logAlways(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.logAlways();
        }
    }

    public RangerPerfTracer(Logger logger, String tag, String data, ThreadInfo threadInfo) {
        this.logger = logger;
        this.tag = tag;
        this.data = data;
        this.threadInfo = threadInfo;
        this.startTime = threadInfo == null ? System.nanoTime() : RangerPerfTracerFactory.threadMgmtBean.getThreadCpuTime(threadInfo.getThreadId());
        this.userStartTime = System.nanoTime();
    }

    public final long getElapsedUserTime() {
        return System.nanoTime() - this.userStartTime;
    }

    public final long getElapsedCpuTime() {
        if (this.threadInfo == null) {
            return this.getElapsedUserTime();
        }
        return RangerPerfTracerFactory.threadMgmtBean.getThreadCpuTime(this.threadInfo.getThreadId()) - this.startTime;
    }

    public void log() {
        long reportingThreshold;
        long elapsedTime = Math.max(this.getElapsedUserTime(), this.getElapsedCpuTime());
        long l = reportingThreshold = this.threadInfo == null ? 0L : 999L;
        if (elapsedTime > reportingThreshold) {
            this.logger.debug("[PERF]:" + (this.threadInfo != null ? this.threadInfo.getThreadName() : "") + ":" + this.tag + this.data + ":" + this.getElapsedCpuTime() + ":" + this.getElapsedUserTime());
        }
    }

    public void logAlways() {
        this.logger.debug("[PERF]:" + (this.threadInfo != null ? this.threadInfo.getThreadName() : "") + ":" + this.tag + this.data + ":" + this.getElapsedCpuTime() + ":" + this.getElapsedUserTime());
    }
}

