/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerRequestScriptEvaluator;
import org.apache.ranger.plugin.util.ScriptEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerScriptConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerScriptConditionEvaluator.class);
    private ScriptEngine scriptEngine;
    private Boolean enableJsonCtx = null;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerScriptConditionEvaluator.init(" + this.condition + ")");
        }
        super.init();
        String engineName = "JavaScript";
        Map<String, String> evalOptions = this.conditionDef.getEvaluatorOptions();
        if (MapUtils.isNotEmpty(evalOptions)) {
            engineName = evalOptions.get("engineName");
            String strEnableJsonCtx = evalOptions.get("enableJsonCtx");
            if (StringUtils.isNotEmpty((CharSequence)strEnableJsonCtx)) {
                this.enableJsonCtx = Boolean.parseBoolean(strEnableJsonCtx);
            }
        }
        if (StringUtils.isBlank((CharSequence)engineName)) {
            engineName = "JavaScript";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerScriptConditionEvaluator.init() - engineName=" + engineName);
        }
        this.scriptEngine = ScriptEngineUtil.createScriptEngine(this.serviceDef.getName());
        if (this.scriptEngine == null) {
            String conditionType = this.condition != null ? this.condition.getType() : null;
            LOG.error("failed to initialize condition '" + conditionType + "': script engine '" + engineName + "' was not created");
        } else {
            LOG.info("ScriptEngine for engineName=[" + engineName + "] is successfully created");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerScriptConditionEvaluator.init(" + this.condition + ")");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerScriptConditionEvaluator.isMatched()");
        }
        boolean result = true;
        if (this.scriptEngine != null) {
            String script = this.getScript();
            if (StringUtils.isNotBlank((CharSequence)script)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerScriptConditionEvaluator.isMatched(): script={" + script + "}");
                }
                if (this.enableJsonCtx == null) {
                    this.enableJsonCtx = RangerRequestScriptEvaluator.needsJsonCtxEnabled(script);
                }
                RangerRequestScriptEvaluator evaluator = new RangerRequestScriptEvaluator(request, this.scriptEngine, this.enableJsonCtx);
                evaluator.evaluateConditionScript(script);
                result = evaluator.getResult();
            } else {
                String conditionType = this.condition != null ? this.condition.getType() : null;
                LOG.error("failed to evaluate condition '" + conditionType + "': script is empty");
            }
        } else {
            String conditionType = this.condition != null ? this.condition.getType() : null;
            LOG.error("failed to evaluate condition '" + conditionType + "': script engine not found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerScriptConditionEvaluator.isMatched(), result=" + result);
        }
        return result;
    }

    protected String getScript() {
        String value;
        String ret = null;
        List<String> values = this.condition.getValues();
        if (CollectionUtils.isNotEmpty(values) && StringUtils.isNotBlank((CharSequence)(value = values.get(0)))) {
            ret = value.trim();
        }
        return ret;
    }
}

