/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.DnsRecordSet;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.dns.implementation.ARecordSetImpl;
import com.microsoft.azure.management.dns.implementation.AaaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.CNameRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.CaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.MXRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.NSRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.PtrRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.azure.management.dns.implementation.SoaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.SrvRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.TxtRecordSetImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;

@LangDefinition
class DnsRecordSetsImpl
extends ExternalChildResourcesNonCachedImpl<DnsRecordSetImpl, DnsRecordSet, RecordSetInner, DnsZoneImpl, DnsZone> {
    private final long defaultTtlInSeconds = 3600L;

    DnsRecordSetsImpl(DnsZoneImpl parent) {
        super((Object)parent, parent.taskGroup(), "RecordSet");
    }

    DnsRecordSetImpl defineARecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    void withCNameRecordSet(String name, String alias) {
        CNameRecordSetImpl recordSet = CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent());
        ((RecordSetInner)recordSet.inner()).cnameRecord().withCname(alias);
        this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(recordSet.withTimeToLive(3600L)));
    }

    DnsRecordSetImpl defineCaaRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineCNameRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineMXRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineNSRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl definePtrRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareInlineDefine(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl updateARecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateAaaaRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateMXRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateCaaRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateCNameRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateNSRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updatePtrRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateSrvRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateTxtRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateSoaRecordSet() {
        return (DnsRecordSetImpl)this.prepareInlineUpdate(SoaRecordSetImpl.newRecordSet((DnsZoneImpl)this.parent()));
    }

    void withoutARecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutAaaaRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutCaaRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(CaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutCNameRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutMXRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutNSRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutPtrRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutSrvRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutTxtRecordSet(String name, String eTagValue) {
        this.prepareInlineRemove(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    private DnsRecordSetImpl setDefaults(DnsRecordSetImpl recordSet) {
        return recordSet.withTimeToLive(3600L);
    }
}

