/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapperUtil;
import org.apache.ranger.tagsync.source.atlas.EntityNotificationWrapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntityWithTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasNotificationMapper {
    private static final int REPORTING_INTERVAL_FOR_UNHANDLED_ENTITYTYPE_IN_MILLIS = 300000;
    private static final Logger LOG = LoggerFactory.getLogger(AtlasNotificationMapper.class);
    private static Map<String, Long> unhandledEventTypes = new HashMap<String, Long>();

    public static void logUnhandledEntityNotification(EntityNotificationWrapper entityNotification) {
        boolean skipLogging;
        boolean bl = skipLogging = entityNotification.getIsEntityCreateOp() && entityNotification.getIsEmptyClassifications();
        if (!skipLogging) {
            boolean loggingNeeded = false;
            String entityTypeName = entityNotification.getEntityTypeName();
            if (entityTypeName != null) {
                Long timeInMillis = unhandledEventTypes.get(entityTypeName);
                long currentTimeInMillis = System.currentTimeMillis();
                if (timeInMillis == null || currentTimeInMillis - timeInMillis >= 300000L) {
                    unhandledEventTypes.put(entityTypeName, currentTimeInMillis);
                    loggingNeeded = true;
                }
            } else {
                LOG.error("EntityNotification contains NULL entity or NULL entity-type");
            }
            if (loggingNeeded) {
                if (!entityNotification.getIsEntityTypeHandled()) {
                    LOG.warn("Tag-sync is not enabled to handle notifications for Entity-type:[" + entityNotification.getEntityTypeName() + "]");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dropped process entity notification for Atlas-Entity [" + entityNotification.getRangerAtlasEntity() + "]");
                }
            }
        }
    }

    public static Map<String, ServiceTags> processAtlasEntities(List<RangerAtlasEntityWithTags> atlasEntities) {
        Map<String, ServiceTags> ret = null;
        try {
            ret = AtlasNotificationMapper.buildServiceTags(atlasEntities);
        }
        catch (Exception exception) {
            LOG.error("Failed to build serviceTags", (Throwable)exception);
        }
        return ret;
    }

    public static boolean isNotificationHandled(EntityNotificationWrapper entityNotification) {
        boolean ret = false;
        EntityNotificationWrapper.NotificationOpType opType = entityNotification.getOpType();
        if (opType != null) {
            switch (opType) {
                case ENTITY_CREATE: {
                    boolean bl = ret = entityNotification.getIsEntityActive() && !entityNotification.getIsEmptyClassifications();
                    if (ret || !LOG.isDebugEnabled()) break;
                    LOG.debug("ENTITY_CREATE notification is ignored, as there are no traits associated with the entity. Ranger will get necessary information from any subsequent TRAIT_ADDED notification");
                    break;
                }
                case ENTITY_UPDATE: {
                    boolean bl = ret = entityNotification.getIsEntityActive() && !entityNotification.getIsEmptyClassifications();
                    if (ret || !LOG.isDebugEnabled()) break;
                    LOG.debug("ENTITY_UPDATE notification is ignored, as there are no traits associated with the entity.");
                    break;
                }
                case ENTITY_DELETE: {
                    ret = true;
                    break;
                }
                case CLASSIFICATION_ADD: 
                case CLASSIFICATION_UPDATE: 
                case CLASSIFICATION_DELETE: {
                    ret = entityNotification.getIsEntityActive();
                    break;
                }
                default: {
                    LOG.error((Object)((Object)opType) + ": unknown notification received - not handled");
                }
            }
            if (ret) {
                ret = entityNotification.getIsEntityTypeHandled();
            }
            if (!ret && LOG.isDebugEnabled()) {
                LOG.debug("Notification : [" + entityNotification + "] will NOT be processed.");
            }
        }
        return ret;
    }

    private static Map<String, ServiceTags> buildServiceTags(List<RangerAtlasEntityWithTags> entitiesWithTags) {
        HashMap<String, ServiceTags> ret = new HashMap<String, ServiceTags>();
        for (RangerAtlasEntityWithTags rangerAtlasEntityWithTags : entitiesWithTags) {
            RangerAtlasEntity entity = rangerAtlasEntityWithTags.getEntity();
            if (entity != null) {
                AtlasNotificationMapper.buildServiceTags(rangerAtlasEntityWithTags, ret);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Ignoring entity because its State is not ACTIVE: " + rangerAtlasEntityWithTags);
        }
        if (CollectionUtils.isNotEmpty(ret.values())) {
            for (ServiceTags serviceTags : ret.values()) {
                if (!MapUtils.isNotEmpty((Map)serviceTags.getTagDefinitions())) continue;
                HashMap<String, RangerTagDef> uniqueTagDefs = new HashMap<String, RangerTagDef>();
                for (RangerTagDef tagDef : serviceTags.getTagDefinitions().values()) {
                    RangerTagDef existingTagDef = (RangerTagDef)uniqueTagDefs.get(tagDef.getName());
                    if (existingTagDef == null) {
                        uniqueTagDefs.put(tagDef.getName(), tagDef);
                        continue;
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)tagDef.getAttributeDefs())) continue;
                    for (RangerTagDef.RangerTagAttributeDef tagAttrDef : tagDef.getAttributeDefs()) {
                        boolean attrDefExists = false;
                        if (CollectionUtils.isNotEmpty((Collection)existingTagDef.getAttributeDefs())) {
                            for (RangerTagDef.RangerTagAttributeDef existingTagAttrDef : existingTagDef.getAttributeDefs()) {
                                if (!StringUtils.equalsIgnoreCase((CharSequence)existingTagAttrDef.getName(), (CharSequence)tagAttrDef.getName())) continue;
                                attrDefExists = true;
                                break;
                            }
                        }
                        if (attrDefExists) continue;
                        existingTagDef.getAttributeDefs().add(tagAttrDef);
                    }
                }
                serviceTags.getTagDefinitions().clear();
                for (RangerTagDef tagDef : uniqueTagDefs.values()) {
                    serviceTags.getTagDefinitions().put(tagDef.getId(), tagDef);
                }
            }
        }
        if (MapUtils.isNotEmpty(ret)) {
            for (Map.Entry entry : ret.entrySet()) {
                ServiceTags serviceTags = (ServiceTags)entry.getValue();
                serviceTags.setOp("replace");
            }
        }
        return ret;
    }

    private static ServiceTags buildServiceTags(RangerAtlasEntityWithTags entityWithTags, Map<String, ServiceTags> serviceTagsMap) {
        ServiceTags ret = null;
        RangerAtlasEntity entity = entityWithTags.getEntity();
        RangerServiceResource serviceResource = AtlasResourceMapperUtil.getRangerServiceResource(entity);
        if (serviceResource != null) {
            List<RangerTag> tags = AtlasNotificationMapper.getTags(entityWithTags);
            List<RangerTagDef> tagDefs = AtlasNotificationMapper.getTagDefs(entityWithTags);
            String serviceName = serviceResource.getServiceName();
            ret = AtlasNotificationMapper.createOrGetServiceTags(serviceTagsMap, serviceName);
            serviceResource.setId(Long.valueOf(ret.getServiceResources().size()));
            ret.getServiceResources().add(serviceResource);
            ArrayList<Long> tagIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(tags)) {
                for (RangerTag tag : tags) {
                    tag.setId(Long.valueOf(ret.getTags().size()));
                    ret.getTags().put(tag.getId(), tag);
                    tagIds.add(tag.getId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Entity " + entityWithTags + " does not have any tags associated with it");
            }
            ret.getResourceToTagIds().put(serviceResource.getId(), tagIds);
            if (CollectionUtils.isNotEmpty(tagDefs)) {
                for (RangerTagDef tagDef : tagDefs) {
                    tagDef.setId(Long.valueOf(ret.getTagDefinitions().size()));
                    ret.getTagDefinitions().put(tagDef.getId(), tagDef);
                }
            }
        } else {
            LOG.error("Failed to build serviceResource for entity:" + entity.getGuid());
        }
        return ret;
    }

    private static ServiceTags createOrGetServiceTags(Map<String, ServiceTags> serviceTagsMap, String serviceName) {
        ServiceTags ret;
        ServiceTags serviceTags = ret = serviceTagsMap == null ? null : serviceTagsMap.get(serviceName);
        if (ret == null) {
            ret = new ServiceTags();
            if (serviceTagsMap != null) {
                serviceTagsMap.put(serviceName, ret);
            }
            ret.setOp("add_or_update");
            ret.setServiceName(serviceName);
        }
        return ret;
    }

    private static List<RangerTag> getTags(RangerAtlasEntityWithTags entityWithTags) {
        ArrayList<RangerTag> ret = new ArrayList<RangerTag>();
        if (entityWithTags != null && CollectionUtils.isNotEmpty(entityWithTags.getTags())) {
            List<EntityNotificationWrapper.RangerAtlasClassification> tags = entityWithTags.getTags();
            for (EntityNotificationWrapper.RangerAtlasClassification tag : tags) {
                RangerTag rangerTag = new RangerTag(null, tag.getName(), tag.getAttributes(), Short.valueOf((short)0));
                List<RangerValiditySchedule> validityPeriods = tag.getValidityPeriods();
                if (CollectionUtils.isNotEmpty(validityPeriods)) {
                    rangerTag.setValidityPeriods(validityPeriods);
                }
                ret.add(rangerTag);
            }
        }
        return ret;
    }

    private static List<RangerTagDef> getTagDefs(RangerAtlasEntityWithTags entityWithTags) {
        ArrayList<RangerTagDef> ret = new ArrayList<RangerTagDef>();
        if (entityWithTags != null && CollectionUtils.isNotEmpty(entityWithTags.getTags())) {
            HashMap<String, String> tagNames = new HashMap<String, String>();
            for (EntityNotificationWrapper.RangerAtlasClassification tag : entityWithTags.getTags()) {
                if (tagNames.containsKey(tag.getName())) continue;
                tagNames.put(tag.getName(), tag.getName());
                RangerTagDef tagDef = new RangerTagDef(tag.getName(), "Atlas");
                if (MapUtils.isNotEmpty(tag.getAttributes())) {
                    ArrayList<RangerTagDef.RangerTagAttributeDef> attributeDefs = tagDef.getAttributeDefs();
                    if (attributeDefs == null) {
                        attributeDefs = new ArrayList<RangerTagDef.RangerTagAttributeDef>();
                    }
                    for (String attributeName : tag.getAttributes().keySet()) {
                        attributeDefs.add(new RangerTagDef.RangerTagAttributeDef(attributeName, entityWithTags.getTagAttributeType(tag.getName(), attributeName)));
                    }
                    tagDef.setAttributeDefs(attributeDefs);
                }
                ret.add(tagDef);
            }
        }
        return ret;
    }
}

