/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.apache.ranger.tagsync.source.atlas.AtlasAdlsResourceMapper;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasResourceMapperUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasResourceMapperUtil.class);
    private static Map<String, AtlasResourceMapper> atlasResourceMappers = new HashMap<String, AtlasResourceMapper>();

    public static boolean isEntityTypeHandled(String entityTypeName) {
        AtlasResourceMapper mapper;
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isEntityTypeHandled(entityTypeName=" + entityTypeName + ")");
        }
        boolean bl = ret = (mapper = atlasResourceMappers.get(entityTypeName)) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isEntityTypeHandled(entityTypeName=" + entityTypeName + ") : " + ret);
        }
        return ret;
    }

    public static RangerServiceResource getRangerServiceResource(RangerAtlasEntity atlasEntity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getRangerServiceResource(" + atlasEntity.getGuid() + ")");
        }
        RangerServiceResource resource = null;
        AtlasResourceMapper mapper = atlasResourceMappers.get(atlasEntity.getTypeName());
        if (mapper != null) {
            try {
                resource = mapper.buildResource(atlasEntity);
            }
            catch (Exception exception) {
                LOG.error("Could not get serviceResource for atlas entity:" + atlasEntity.getGuid() + ": ", (Throwable)exception);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRangerServiceResource(" + atlasEntity.getGuid() + "): resource=" + resource);
        }
        return resource;
    }

    public static boolean initializeAtlasResourceMappers(Properties properties) {
        String MAPPER_NAME_DELIMITER = ",";
        String customMapperNames = TagSyncConfig.getCustomAtlasResourceMappers(properties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> initializeAtlasResourceMappers.initializeAtlasResourceMappers(" + customMapperNames + ")");
        }
        boolean ret = true;
        ArrayList<String> mapperNames = new ArrayList<String>();
        mapperNames.add("org.apache.ranger.tagsync.source.atlas.AtlasHiveResourceMapper");
        mapperNames.add("org.apache.ranger.tagsync.source.atlas.AtlasHdfsResourceMapper");
        mapperNames.add("org.apache.ranger.tagsync.source.atlas.AtlasHbaseResourceMapper");
        mapperNames.add("org.apache.ranger.tagsync.source.atlas.AtlasKafkaResourceMapper");
        mapperNames.add("org.apache.ranger.tagsync.source.atlas.AtlasOzoneResourceMapper");
        mapperNames.add(AtlasAdlsResourceMapper.class.getName());
        if (StringUtils.isNotBlank((CharSequence)customMapperNames)) {
            for (String customMapperName : customMapperNames.split(",")) {
                mapperNames.add(customMapperName.trim());
            }
        }
        for (String mapperName : mapperNames) {
            try {
                Class<?> clazz = Class.forName(mapperName);
                AtlasResourceMapper resourceMapper = (AtlasResourceMapper)clazz.newInstance();
                resourceMapper.initialize(properties);
                for (String entityTypeName : resourceMapper.getSupportedEntityTypes()) {
                    AtlasResourceMapperUtil.add(entityTypeName, resourceMapper);
                }
            }
            catch (Exception exception) {
                LOG.error("Failed to create AtlasResourceMapper:" + mapperName + ": ", (Throwable)exception);
                ret = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== initializeAtlasResourceMappers.initializeAtlasResourceMappers(" + mapperNames + "): " + ret);
        }
        return ret;
    }

    private static void add(String entityType, AtlasResourceMapper mapper) {
        atlasResourceMappers.put(entityType, mapper);
    }
}

