/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.debug.server;

import java.io.File;
import java.io.IOException;
import org.apache.ratis.examples.common.Constants;
import org.apache.ratis.examples.counter.server.CounterServer;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.util.TimeDuration;

public final class Server {
    private Server() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("The arguments should be <ip:port>");
            System.exit(1);
        }
        RaftPeer currentPeer = Constants.PEERS.stream().filter(raftPeer -> raftPeer.getAddress().equals(args[0])).findFirst().orElseThrow(() -> new IllegalArgumentException("Peer not found: " + args[0]));
        File storageDir = new File(Constants.PATH, currentPeer.getId().toString());
        CounterServer counterServer = new CounterServer(currentPeer, storageDir, TimeDuration.ZERO);
        counterServer.start();
    }
}

