/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view;

import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.RandomSupplier;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoirFactory;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData> Aggregator<T> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilterInternal exemplarFilter, MemoryMode memoryMode) {
        ExemplarReservoirFactory reservoirFactory = ExemplarReservoirFactory.filtered(exemplarFilter, ExemplarReservoirFactory.fixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        InstrumentType instrumentType = instrumentDescriptor.getType();
        return instrumentType == InstrumentType.OBSERVABLE_GAUGE || instrumentType == InstrumentType.GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

