/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.PluginConfiguration;
import org.apache.shardingsphere.agent.core.spi.AgentServiceLoader;
import org.apache.shardingsphere.agent.spi.PluginLifecycleService;

public final class PluginLifecycleServiceManager {
    private static final AtomicBoolean STARTED_FLAG = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger(PluginLifecycleServiceManager.class.getName());

    public static void init(Map<String, PluginConfiguration> pluginConfigs, Collection<JarFile> pluginJars, ClassLoader pluginClassLoader, boolean isEnhancedForProxy) {
        if (STARTED_FLAG.compareAndSet(false, true)) {
            PluginLifecycleServiceManager.start(pluginConfigs, pluginClassLoader, isEnhancedForProxy);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> PluginLifecycleServiceManager.close(pluginJars)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start(Map<String, PluginConfiguration> pluginConfigs, ClassLoader pluginClassLoader, boolean isEnhancedForProxy) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            for (Map.Entry<String, PluginConfiguration> entry : pluginConfigs.entrySet()) {
                AgentServiceLoader.getServiceLoader(PluginLifecycleService.class).getServices().stream().filter(each -> each.getType().equalsIgnoreCase((String)entry.getKey())).findFirst().ifPresent(optional -> PluginLifecycleServiceManager.start((PluginConfiguration)entry.getValue(), optional, isEnhancedForProxy));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static void start(PluginConfiguration pluginConfig, PluginLifecycleService pluginLifecycleService, boolean isEnhancedForProxy) {
        try {
            LOGGER.log(Level.INFO, "Start plugin: {0}", new String[]{pluginLifecycleService.getType()});
            pluginLifecycleService.start(pluginConfig, isEnhancedForProxy);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Failed to start service {0}.", new String[]{ex.getMessage()});
        }
    }

    private static void close(Collection<JarFile> pluginJars) {
        AgentServiceLoader.getServiceLoader(PluginLifecycleService.class).getServices().forEach(PluginLifecycleService::close);
        pluginJars.forEach(each -> {
            try {
                each.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Failed to close jar file {0}.", new String[]{ex.getMessage()});
            }
        });
    }

    @Generated
    private PluginLifecycleServiceManager() {
    }
}

