/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.state.coordinator;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.GlobalDataChangedEventHandler;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.CoordinatorType;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.table.TableCoordinatorNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.table.TableCoordinatorTypeNodePath;

public final class TableCoordinatorChangedHandler
implements GlobalDataChangedEventHandler {
    private final YamlTableSwapper swapper = new YamlTableSwapper();

    @Override
    public NodePath getSubscribedNodePath() {
        return new TableCoordinatorNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Collections.singletonList(DataChangedEvent.Type.ADDED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        String eventKey = event.getKey();
        if (!NodePathSearcher.isMatchedPath((String)eventKey, (NodePathSearchCriteria)TableCoordinatorTypeNodePath.createTableSearchCriteria())) {
            return;
        }
        TableCoordinatorTypeNodePath path = new TableCoordinatorTypeNodePath("([\\w-]+(?:[:.][\\w-]+)*)", "([\\w-]+)");
        String qualifiedTableName = NodePathSearcher.get((String)eventKey, (NodePathSearchCriteria)new NodePathSearchCriteria((NodePath)path, true, 1));
        String coordinatorType = NodePathSearcher.get((String)eventKey, (NodePathSearchCriteria)new NodePathSearchCriteria((NodePath)path, false, 2));
        if (Strings.isNullOrEmpty((String)qualifiedTableName) || Strings.isNullOrEmpty((String)coordinatorType)) {
            return;
        }
        List qualifiedTableNames = Splitter.on((String)".").splitToList((CharSequence)qualifiedTableName);
        if (qualifiedTableNames.size() != 3) {
            return;
        }
        this.handle(contextManager, (String)qualifiedTableNames.get(0), (String)qualifiedTableNames.get(1), (String)qualifiedTableNames.get(2), event.getValue(), CoordinatorType.valueOf((String)coordinatorType));
    }

    private void handle(ContextManager contextManager, String databaseName, String schemaName, String tableName, String tableContent, CoordinatorType type) {
        switch (type) {
            case CREATE: {
                this.handleCreatedOrAltered(contextManager, databaseName, schemaName, tableContent);
                break;
            }
            case DROP: {
                this.handleDropped(contextManager, databaseName, schemaName, tableName);
                break;
            }
        }
    }

    private void handleCreatedOrAltered(ContextManager contextManager, String databaseName, String schemaName, String tableContent) {
        ShardingSphereTable alteredTable = this.swapper.swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)tableContent, YamlShardingSphereTable.class));
        contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().alterTable(databaseName, schemaName, alteredTable);
        new StatisticsRefreshEngine(contextManager).asyncRefresh();
    }

    private void handleDropped(ContextManager contextManager, String databaseName, String schemaName, String tableName) {
        contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().dropTable(databaseName, schemaName, tableName);
        new StatisticsRefreshEngine(contextManager).asyncRefresh();
    }
}

