/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.metadata.data.loader;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.DialectMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.TableMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.FirebirdBlobInfoRegistry;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.FirebirdNonFixedLengthColumnSizeRegistry;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.loader.FirebirdBlobColumnLoader;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.loader.FirebirdNonFixedLengthColumnSizeLoader;

public final class FirebirdMetaDataLoader
implements DialectMetaDataLoader {
    public Collection<SchemaMetaData> load(MetaDataLoaderMaterial material) throws SQLException {
        LinkedList tableMetaData = new LinkedList();
        for (String each : material.getActualTableNames()) {
            TableMetaDataLoader.load((DataSource)material.getDataSource(), (String)each, (DatabaseType)material.getStorageType()).ifPresent(tableMetaData::add);
        }
        this.loadBlobColumns(material);
        this.loadNonFixedLengthColumnSizes(material);
        return Collections.singleton(new SchemaMetaData(material.getDefaultSchemaName(), tableMetaData));
    }

    private void loadNonFixedLengthColumnSizes(MetaDataLoaderMaterial material) throws SQLException {
        Map<String, Map<String, Integer>> nonFixedColumnSizes = new FirebirdNonFixedLengthColumnSizeLoader(material).load();
        for (String each : material.getActualTableNames()) {
            Map<String, Integer> tableSizes = nonFixedColumnSizes.getOrDefault(each, Collections.emptyMap());
            FirebirdNonFixedLengthColumnSizeRegistry.refreshTable(material.getDefaultSchemaName(), each, tableSizes);
        }
    }

    private void loadBlobColumns(MetaDataLoaderMaterial material) throws SQLException {
        Map<String, Map<String, Integer>> blobColumns = new FirebirdBlobColumnLoader(material).load();
        for (String each : material.getActualTableNames()) {
            Map<String, Integer> tableColumns = blobColumns.getOrDefault(each, Collections.emptyMap());
            FirebirdBlobInfoRegistry.refreshTable(material.getDefaultSchemaName(), each, tableColumns);
        }
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

