/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.ddl;

import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedCreateViewException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class ShardingCreateViewRouteContextChecker
implements ShardingRouteContextChecker {
    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SelectStatement selectStatement = ((CreateViewStatement)queryContext.getSqlStatementContext().getSqlStatement()).getSelect();
        if (this.isContainsNotSupportedViewStatement(selectStatement, routeContext)) {
            throw new UnsupportedCreateViewException();
        }
    }

    private boolean isContainsNotSupportedViewStatement(SelectStatement selectStatement, RouteContext routeContext) {
        if (routeContext.getRouteUnits().size() <= 1) {
            return false;
        }
        return this.hasGroupBy(selectStatement) || this.hasAggregation(selectStatement) || this.hasDistinct(selectStatement) || this.hasLimit(selectStatement);
    }

    private boolean hasGroupBy(SelectStatement selectStatement) {
        return selectStatement.getGroupBy().map(groupBySegment -> !groupBySegment.getGroupByItems().isEmpty()).orElse(false);
    }

    private boolean hasAggregation(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof AggregationProjectionSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDistinct(SelectStatement selectStatement) {
        return selectStatement.getProjections().isDistinctRow();
    }

    private boolean hasLimit(SelectStatement selectStatement) {
        return selectStatement.getLimit().isPresent();
    }

    @Generated
    public ShardingCreateViewRouteContextChecker() {
    }
}

