/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.unicast;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.sharding.exception.syntax.DataSourceIntersectionNotFoundException;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class ShardingUnicastRouteEngine
implements ShardingRouteEngine {
    private final SQLStatement sqlStatement;
    private final Collection<String> logicTables;
    private final ConnectionContext connectionContext;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        String dataSourceName = this.getDataSourceName(shardingRule.getDataSourceNames());
        RouteMapper dataSourceMapper = new RouteMapper(dataSourceName, dataSourceName);
        if (this.logicTables.isEmpty()) {
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
        } else if (1 == this.logicTables.size()) {
            String logicTableName = this.logicTables.iterator().next();
            if (!shardingRule.findShardingTable(logicTableName).isPresent()) {
                result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
                return result;
            }
            DataNode dataNode = shardingRule.getDataNode(logicTableName);
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataNode.getDataSourceName(), dataNode.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, dataNode.getTableName()))));
        } else {
            this.routeWithMultipleTables(result, shardingRule);
        }
        return result;
    }

    private String getDataSourceName(Collection<String> dataSourceNames) {
        return this.sqlStatement.getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent() || this.isViewStatementContext(this.sqlStatement) ? dataSourceNames.iterator().next() : this.getRandomDataSourceName(dataSourceNames);
    }

    private boolean isViewStatementContext(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateViewStatement || sqlStatement instanceof AlterViewStatement || sqlStatement instanceof DropViewStatement;
    }

    private void routeWithMultipleTables(RouteContext routeContext, ShardingRule shardingRule) {
        ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
        Set availableDataSourceNames = Collections.emptySet();
        boolean first = true;
        for (String each : this.logicTables) {
            ShardingTable shardingTable = shardingRule.getShardingTable(each);
            DataNode dataNode = shardingTable.getActualDataNodes().get(0);
            tableMappers.add(new RouteMapper(each, dataNode.getTableName()));
            Set currentDataSourceNames = shardingTable.getActualDataNodes().stream().map(DataNode::getDataSourceName).collect(Collectors.toCollection(() -> new LinkedHashSet(shardingTable.getActualDataSourceNames().size(), 1.0f)));
            if (first) {
                availableDataSourceNames = currentDataSourceNames;
                first = false;
                continue;
            }
            availableDataSourceNames = Sets.intersection((Set)availableDataSourceNames, (Set)currentDataSourceNames);
        }
        if (availableDataSourceNames.isEmpty()) {
            throw new DataSourceIntersectionNotFoundException(this.logicTables);
        }
        String dataSourceName = this.getDataSourceName(availableDataSourceNames);
        routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), tableMappers));
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        Collection usedDataSourceNames = this.connectionContext.getUsedDataSourceNames();
        ArrayList availableDataSourceNames = new ArrayList(usedDataSourceNames.isEmpty() ? dataSourceNames : usedDataSourceNames);
        return (String)availableDataSourceNames.get(ThreadLocalRandom.current().nextInt(availableDataSourceNames.size()));
    }

    @Generated
    public ShardingUnicastRouteEngine(SQLStatement sqlStatement, Collection<String> logicTables, ConnectionContext connectionContext) {
        this.sqlStatement = sqlStatement;
        this.logicTables = logicTables;
        this.connectionContext = connectionContext;
    }
}

