/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.instance;

import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.elasticjob.kernel.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.kernel.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.kernel.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.kernel.internal.trigger.TriggerNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class InstanceService {
    private final JobNodeStorage jobNodeStorage;
    private final InstanceNode instanceNode;
    private final TriggerNode triggerNode;
    private final ServerService serverService;

    public InstanceService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.triggerNode = new TriggerNode(jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    public void persistOnline() {
        this.jobNodeStorage.fillEphemeralJobNode(this.instanceNode.getLocalInstancePath(), this.instanceNode.getLocalInstanceValue());
    }

    public void removeInstance() {
        this.jobNodeStorage.removeJobNodeIfExisted(this.instanceNode.getLocalInstancePath());
    }

    public List<JobInstance> getAvailableJobInstances() {
        LinkedList<JobInstance> result = new LinkedList<JobInstance>();
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("instances")) {
            JobInstance jobInstance;
            String jobNodeData = this.jobNodeStorage.getJobNodeData(this.instanceNode.getInstancePath(each));
            if (null == jobNodeData || null == (jobInstance = YamlEngine.unmarshal(jobNodeData, JobInstance.class)) || !this.serverService.isEnableServer(jobInstance.getServerIp())) continue;
            result.add(jobInstance);
        }
        return result;
    }

    boolean isLocalJobInstanceExisted() {
        return this.jobNodeStorage.isJobNodeExisted(this.instanceNode.getLocalInstancePath());
    }

    public void triggerAllInstances() {
        this.jobNodeStorage.removeJobNodeIfExisted(this.triggerNode.getTriggerRoot());
        this.jobNodeStorage.getJobNodeChildrenKeys("instances").forEach(each -> this.jobNodeStorage.createJobNodeIfNeeded(this.triggerNode.getTriggerPath((String)each)));
    }
}

