/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.tracing.event;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.spi.tracing.exception.TracingConfigurationException;
import org.apache.shardingsphere.elasticjob.spi.tracing.listener.TracingListenerFactory;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobTracingEventBus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTracingEventBus.class);
    private static final ExecutorService EXECUTOR_SERVICE = JobTracingEventBus.createExecutorService(Runtime.getRuntime().availableProcessors() * 2);
    private final EventBus eventBus;
    private volatile boolean isRegistered;

    public JobTracingEventBus() {
        this.eventBus = null;
    }

    public JobTracingEventBus(TracingConfiguration<?> tracingConfig) {
        this.eventBus = new AsyncEventBus((Executor)EXECUTOR_SERVICE);
        this.register(tracingConfig);
    }

    private static ExecutorService createExecutorService(int threadSize) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadSize, threadSize, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(String.join((CharSequence)"-", "job-event", "%s")).build());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)threadPoolExecutor));
    }

    private void register(TracingConfiguration<?> tracingConfig) {
        try {
            if (null == tracingConfig.getTracingStorageConfiguration()) {
                throw new TracingConfigurationException(String.format("Can not find executor service handler type '%s'.", tracingConfig.getType()));
            }
            this.eventBus.register((Object)((TracingListenerFactory)TypedSPILoader.getService(TracingListenerFactory.class, (Object)tracingConfig.getType())).create(tracingConfig.getTracingStorageConfiguration().getStorage()));
            this.isRegistered = true;
        }
        catch (TracingConfigurationException ex) {
            log.error("Elastic job: create tracing listener failure, error is: ", (Throwable)ex);
        }
    }

    public void post(JobEvent event) {
        if (this.isRegistered && !EXECUTOR_SERVICE.isShutdown()) {
            this.eventBus.post((Object)event);
        }
    }
}

