/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.DispatchExceptionHandler;
import reactor.core.publisher.Mono;

public class HandlerResult {
    private final Object handler;
    @Nullable
    private final Object returnValue;
    private final ResolvableType returnType;
    private final BindingContext bindingContext;
    @Nullable
    private DispatchExceptionHandler exceptionHandler;
    @Nullable
    private Function<Throwable, Mono<HandlerResult>> exceptionHandlerFunction;

    public HandlerResult(Object handler, @Nullable Object returnValue, MethodParameter returnType) {
        this(handler, returnValue, returnType, null);
    }

    public HandlerResult(Object handler, @Nullable Object returnValue, MethodParameter returnType, @Nullable BindingContext context) {
        Assert.notNull((Object)handler, (String)"'handler' is required");
        Assert.notNull((Object)returnType, (String)"'returnType' is required");
        this.handler = handler;
        this.returnValue = returnValue;
        this.returnType = ResolvableType.forMethodParameter((MethodParameter)returnType);
        this.bindingContext = context != null ? context : new BindingContext();
    }

    public Object getHandler() {
        return this.handler;
    }

    @Nullable
    public Object getReturnValue() {
        return this.returnValue;
    }

    public ResolvableType getReturnType() {
        return this.returnType;
    }

    public MethodParameter getReturnTypeSource() {
        return (MethodParameter)this.returnType.getSource();
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public Model getModel() {
        return this.bindingContext.getModel();
    }

    public HandlerResult setExceptionHandler(DispatchExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Nullable
    public DispatchExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Deprecated(since="6.0", forRemoval=true)
    public HandlerResult setExceptionHandler(Function<Throwable, Mono<HandlerResult>> function) {
        this.exceptionHandler = (exchange2, ex) -> (Mono)function.apply(ex);
        this.exceptionHandlerFunction = function;
        return this;
    }

    @Deprecated(since="6.0", forRemoval=true)
    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    @Deprecated(since="6.0", forRemoval=true)
    public Mono<HandlerResult> applyExceptionHandler(Throwable failure) {
        return this.exceptionHandlerFunction != null ? this.exceptionHandlerFunction.apply(failure) : Mono.error((Throwable)failure);
    }
}

