/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.redis.util.RedisAssertions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class RedisCache
extends AbstractValueAdaptingCache {
    static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    static final String CACHE_RETRIEVAL_UNSUPPORTED_OPERATION_EXCEPTION_MESSAGE = "The Redis driver configured with RedisCache through RedisCacheWriter does not support CompletableFuture-based retrieval";
    private final Lock lock = new ReentrantLock();
    private final RedisCacheConfiguration cacheConfiguration;
    private final RedisCacheWriter cacheWriter;
    private final String name;

    protected RedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfiguration) {
        super(RedisAssertions.requireNonNull(cacheConfiguration, "CacheConfiguration must not be null", new Object[0]).getAllowCacheNullValues());
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null");
        this.name = name;
        this.cacheWriter = cacheWriter;
        this.cacheConfiguration = cacheConfiguration;
    }

    public RedisCacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    protected RedisCacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    protected ConversionService getConversionService() {
        return this.getCacheConfiguration().getConversionService();
    }

    public String getName() {
        return this.name;
    }

    public RedisCacheWriter getNativeCache() {
        return this.getCacheWriter();
    }

    public CacheStatistics getStatistics() {
        return this.getCacheWriter().getCacheStatistics(this.getName());
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper result = this.get(key);
        return (T)(result != null ? result.get() : this.getSynchronized(key, valueLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T getSynchronized(Object key, Callable<T> valueLoader) {
        this.lock.lock();
        try {
            Cache.ValueWrapper result = this.get(key);
            Object object = result != null ? result.get() : this.loadCacheValue(key, valueLoader);
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected <T> T loadCacheValue(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Exception ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)ex);
        }
        this.put(key, value);
        return value;
    }

    protected Object lookup(Object key) {
        byte[] binaryKey = this.createAndConvertCacheKey(key);
        byte[] binaryValue = this.getCacheConfiguration().isTimeToIdleEnabled() ? this.getCacheWriter().get(this.getName(), binaryKey, this.getTimeToLive(key)) : this.getCacheWriter().get(this.getName(), binaryKey);
        return binaryValue != null ? this.deserializeCacheValue(binaryValue) : null;
    }

    private Duration getTimeToLive(Object key) {
        return this.getTimeToLive(key, null);
    }

    private Duration getTimeToLive(Object key, @Nullable Object value) {
        return this.getCacheConfiguration().getTtlFunction().getTimeToLive(key, value);
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.processAndCheckValue(value);
        byte[] binaryKey = this.createAndConvertCacheKey(key);
        byte[] binaryValue = this.serializeCacheValue(cacheValue);
        Duration timeToLive = this.getTimeToLive(key, value);
        this.getCacheWriter().put(this.getName(), binaryKey, binaryValue, timeToLive);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (this.nullCacheValueIsNotAllowed(cacheValue)) {
            return this.get(key);
        }
        Duration timeToLive = this.getTimeToLive(key, value);
        byte[] binaryKey = this.createAndConvertCacheKey(key);
        byte[] binaryValue = this.serializeCacheValue(cacheValue);
        byte[] result = this.getCacheWriter().putIfAbsent(this.getName(), binaryKey, binaryValue, timeToLive);
        return result != null ? new SimpleValueWrapper(this.fromStoreValue(this.deserializeCacheValue(result))) : null;
    }

    public void clear() {
        this.clear("*");
    }

    public void clear(String keyPattern) {
        this.getCacheWriter().clean(this.getName(), this.createAndConvertCacheKey(keyPattern));
    }

    public void clearStatistics() {
        this.getCacheWriter().clearStatistics(this.getName());
    }

    public void evict(Object key) {
        this.getCacheWriter().remove(this.getName(), this.createAndConvertCacheKey(key));
    }

    public CompletableFuture<Cache.ValueWrapper> retrieve(Object key) {
        if (!this.getCacheWriter().supportsAsyncRetrieve()) {
            throw new UnsupportedOperationException(CACHE_RETRIEVAL_UNSUPPORTED_OPERATION_EXCEPTION_MESSAGE);
        }
        return this.retrieveValue(key);
    }

    public <T> CompletableFuture<T> retrieve(Object key, Supplier<CompletableFuture<T>> valueLoader) {
        return this.retrieve(key).thenCompose(wrapper -> {
            if (wrapper != null) {
                return CompletableFuture.completedFuture(wrapper.get());
            }
            return ((CompletableFuture)valueLoader.get()).thenCompose(value -> {
                Object cacheValue = this.processAndCheckValue(value);
                byte[] binaryKey = this.createAndConvertCacheKey(key);
                byte[] binaryValue = this.serializeCacheValue(cacheValue);
                Duration timeToLive = this.getTimeToLive(key, cacheValue);
                return this.getCacheWriter().store(this.getName(), binaryKey, binaryValue, timeToLive).thenApply(v -> value);
            });
        });
    }

    private Object processAndCheckValue(@Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (this.nullCacheValueIsNotAllowed(cacheValue)) {
            String message = String.format("Cache '%s' does not allow 'null' values; Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration", this.getName());
            throw new IllegalArgumentException(message);
        }
        return cacheValue;
    }

    @Nullable
    protected Object preProcessCacheValue(@Nullable Object value) {
        return value != null ? value : (this.isAllowNullValues() ? NullValue.INSTANCE : null);
    }

    protected byte[] serializeCacheKey(String cacheKey) {
        return ByteUtils.getBytes(this.getCacheConfiguration().getKeySerializationPair().write(cacheKey));
    }

    protected byte[] serializeCacheValue(Object value) {
        if (this.isAllowNullValues() && value instanceof NullValue) {
            return BINARY_NULL_VALUE;
        }
        return ByteUtils.getBytes(this.getCacheConfiguration().getValueSerializationPair().write(value));
    }

    @Nullable
    protected Object deserializeCacheValue(byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.getCacheConfiguration().getValueSerializationPair().read(ByteBuffer.wrap(value));
    }

    protected String createCacheKey(Object key) {
        String convertedKey = this.convertKey(key);
        return this.getCacheConfiguration().usePrefix() ? this.prefixCacheKey(convertedKey) : convertedKey;
    }

    protected String convertKey(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            return stringKey;
        }
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        ConversionService conversionService = this.getConversionService();
        if (conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            try {
                return (String)conversionService.convert(key, String.class);
            }
            catch (ConversionFailedException ex) {
                if (this.isCollectionLikeOrMap(source)) {
                    return this.convertCollectionLikeOrMapKey(key, source);
                }
                throw ex;
            }
        }
        if (this.hasToStringMethod(key)) {
            return key.toString();
        }
        String message = String.format("Cannot convert cache key %s to String; Please register a suitable Converter via 'RedisCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'", source, key.getClass().getName());
        throw new IllegalStateException(message);
    }

    private CompletableFuture<Cache.ValueWrapper> retrieveValue(Object key) {
        return ((CompletableFuture)this.getCacheWriter().retrieve(this.getName(), this.createAndConvertCacheKey(key)).thenApply(binaryValue -> binaryValue != null ? this.deserializeCacheValue((byte[])binaryValue) : null)).thenApply(x$0 -> this.toValueWrapper(x$0));
    }

    @Nullable
    private Object nullSafeDeserializedStoreValue(@Nullable byte[] value) {
        return value != null ? this.fromStoreValue(this.deserializeCacheValue(value)) : null;
    }

    private boolean hasToStringMethod(Object target) {
        return this.hasToStringMethod(target.getClass());
    }

    private boolean hasToStringMethod(Class<?> type) {
        Method toString = ReflectionUtils.findMethod(type, (String)"toString");
        return toString != null && !Object.class.equals(toString.getDeclaringClass());
    }

    private boolean isCollectionLikeOrMap(TypeDescriptor source) {
        return source.isArray() || source.isCollection() || source.isMap();
    }

    private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
        if (source.isMap()) {
            int count = 0;
            StringBuilder target = new StringBuilder("{");
            for (Map.Entry entry : ((Map)key).entrySet()) {
                target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
                target.append(++count > 1 ? ", " : "");
            }
            target.append("}");
            return target.toString();
        }
        if (source.isCollection() || source.isArray()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
            for (Object e : collection) {
                stringJoiner.add(this.convertKey(e));
            }
            return "[" + stringJoiner + "]";
        }
        throw new IllegalArgumentException(String.format("Cannot convert cache key [%s] to String", key));
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private String prefixCacheKey(String key) {
        return this.getCacheConfiguration().getKeyPrefixFor(this.getName()) + key;
    }

    private boolean nullCacheValueIsNotAllowed(@Nullable Object cacheValue) {
        return cacheValue == null && !this.isAllowNullValues();
    }
}

