/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.request;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import reactor.core.publisher.Flux;

public class BodyWriterExchange
extends ServerWebExchangeDecorator {
    private final String body;
    private final String contentType;
    private final CachedBodyOutputMessage cachedBodyOutputMessage;

    public BodyWriterExchange(ServerWebExchange delegate, String body) {
        super(delegate);
        this.body = body;
        HttpHeaders headers = delegate.getRequest().getHeaders();
        this.contentType = headers.getFirst("Content-Type");
        this.cachedBodyOutputMessage = ResponseUtils.newCachedBodyOutputMessage((ServerWebExchange)delegate);
        this.initializeBody();
    }

    private void initializeBody() {
        String bodyContent = this.getFormattedBody();
        BodyInserter bodyInserter = BodyInserters.fromValue((Object)bodyContent);
        bodyInserter.insert((ReactiveHttpOutputMessage)this.cachedBodyOutputMessage, (BodyInserter.Context)new BodyInserterContext()).subscribe();
    }

    private String getFormattedBody() {
        if (Objects.isNull(this.contentType)) {
            return this.body;
        }
        if (this.contentType.contains("application/json")) {
            return this.body;
        }
        if (this.contentType.contains("application/x-www-form-urlencoded")) {
            return this.body;
        }
        if (this.contentType.contains("multipart/form-data")) {
            return this.body;
        }
        return this.body;
    }

    public ServerHttpRequest getRequest() {
        return new ServerHttpRequestDecorator(super.getRequest()){

            public Flux<DataBuffer> getBody() {
                return BodyWriterExchange.this.cachedBodyOutputMessage.getBody();
            }

            public HttpHeaders getHeaders() {
                HttpHeaders originalHeaders = super.getHeaders();
                HttpHeaders newHeaders = new HttpHeaders();
                newHeaders.putAll((Map)originalHeaders);
                if (Objects.nonNull(BodyWriterExchange.this.body)) {
                    byte[] bodyBytes = BodyWriterExchange.this.getFormattedBody().getBytes(StandardCharsets.UTF_8);
                    newHeaders.setContentLength((long)bodyBytes.length);
                }
                return newHeaders;
            }
        };
    }
}

