/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;

public class IOUtils {
    private static final int BUFFER_SIZE = 8192;
    public static final int EOF = -1;

    private IOUtils() {
    }

    public static long write(InputStream is, OutputStream os) throws IOException {
        return IOUtils.write(is, os, 8192);
    }

    public static long write(InputStream is, OutputStream os, int bufferSize) throws IOException {
        byte[] buff = new byte[bufferSize];
        return IOUtils.write(is, os, buff);
    }

    public static long write(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String read(Reader reader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            IOUtils.write(reader, writer);
            String string = writer.getBuffer().toString();
            return string;
        }
    }

    public static long write(Writer writer, String string) throws IOException {
        try (StringReader reader = new StringReader(string);){
            long l = IOUtils.write(reader, writer);
            return l;
        }
    }

    public static long write(Reader reader, Writer writer) throws IOException {
        return IOUtils.write(reader, writer, 8192);
    }

    public static long write(Reader reader, Writer writer, int bufferSize) throws IOException {
        int read;
        long total = 0L;
        char[] buf = new char[bufferSize];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
            total += (long)read;
        }
        return total;
    }

    public static String[] readLines(File file) throws IOException {
        if (file == null || !file.exists() || !file.canRead()) {
            return new String[0];
        }
        return IOUtils.readLines(new FileInputStream(file));
    }

    public static String[] readLines(InputStream is) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[0]);
            return stringArray;
        }
    }

    public static String read(InputStream is, String encoding) throws IOException {
        int len;
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(is, encoding);
        char[] buf = new char[1024];
        while ((len = inputStreamReader.read(buf)) != -1) {
            stringBuilder.append(buf, 0, len);
        }
        inputStreamReader.close();
        return stringBuilder.toString();
    }

    public static void writeLines(OutputStream os, String[] lines) throws IOException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));){
            for (String line : lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    public static void writeLines(File file, String[] lines) throws IOException {
        if (file == null) {
            throw new IOException("File is null.");
        }
        IOUtils.writeLines(new FileOutputStream(file), lines);
    }

    public static void appendLines(File file, String[] lines) throws IOException {
        if (file == null) {
            throw new IOException("File is null.");
        }
        IOUtils.writeLines(new FileOutputStream(file, true), lines);
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            ClassLoader cl = ClassUtils.getClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[1024];
            while (-1 != (n = inputStream.read(buffer))) {
                byteArrayOutputStream.write(buffer, 0, n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }
}

