/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.metrics.registry.collector.RegistryMetricsCollector;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryEvent
extends TimeCounterEvent {
    private static final TypeWrapper REGISTER_EVENT = new TypeWrapper(MetricsLevel.APP, MetricsKey.REGISTER_METRIC_REQUESTS, MetricsKey.REGISTER_METRIC_REQUESTS_SUCCEED, MetricsKey.REGISTER_METRIC_REQUESTS_FAILED);
    private static final TypeWrapper SUBSCRIBE_EVENT = new TypeWrapper(MetricsLevel.APP, MetricsKey.SUBSCRIBE_METRIC_NUM, MetricsKey.SUBSCRIBE_METRIC_NUM_SUCCEED, MetricsKey.SUBSCRIBE_METRIC_NUM_FAILED);
    private static final TypeWrapper NOTIFY_EVENT = new TypeWrapper(MetricsLevel.APP, MetricsKey.NOTIFY_METRIC_REQUESTS, MetricsKey.NOTIFY_METRIC_NUM_LAST, null);
    private static final TypeWrapper RS_EVENT = new TypeWrapper(MetricsLevel.SERVICE, MetricsKey.SERVICE_REGISTER_METRIC_REQUESTS, MetricsKey.SERVICE_REGISTER_METRIC_REQUESTS_SUCCEED, MetricsKey.SERVICE_REGISTER_METRIC_REQUESTS_FAILED);
    private static final TypeWrapper SS_EVENT = new TypeWrapper(MetricsLevel.SERVICE, MetricsKey.SERVICE_SUBSCRIBE_METRIC_NUM, MetricsKey.SERVICE_SUBSCRIBE_METRIC_NUM_SUCCEED, MetricsKey.SERVICE_SUBSCRIBE_METRIC_NUM_FAILED);
    private static final TypeWrapper DIRECTORY_EVENT = new TypeWrapper(MetricsLevel.APP, MetricsKey.DIRECTORY_METRIC_NUM_VALID, null, null);

    public RegistryEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel, typeWrapper);
        ScopeBeanFactory beanFactory = this.getSource().getBeanFactory();
        if (!beanFactory.isDestroyed()) {
            RegistryMetricsCollector collector = beanFactory.getBean(RegistryMetricsCollector.class);
            super.setAvailable(collector != null && collector.isCollectEnabled());
        }
    }

    public static RegistryEvent toRegisterEvent(ApplicationModel applicationModel, List<String> registryClusterNames) {
        RegistryEvent registryEvent = new RegistryEvent(applicationModel, REGISTER_EVENT);
        registryEvent.putAttachment("registryKey", registryClusterNames);
        return registryEvent;
    }

    public static RegistryEvent toSubscribeEvent(ApplicationModel applicationModel, String registryClusterName) {
        RegistryEvent ddEvent = new RegistryEvent(applicationModel, SUBSCRIBE_EVENT);
        ddEvent.putAttachment("registryKey", Collections.singletonList(registryClusterName));
        return ddEvent;
    }

    public static RegistryEvent toNotifyEvent(ApplicationModel applicationModel) {
        return new RegistryEvent(applicationModel, NOTIFY_EVENT){

            @Override
            public void customAfterPost(Object postResult) {
                super.putAttachment("lastNumMap", postResult);
            }
        };
    }

    public static RegistryEvent toRsEvent(ApplicationModel applicationModel, String serviceKey, int size, List<String> serviceDiscoveryNames) {
        RegistryEvent ddEvent = new RegistryEvent(applicationModel, RS_EVENT);
        ddEvent.putAttachment("serviceKey", serviceKey);
        ddEvent.putAttachment("size", size);
        ddEvent.putAttachment("registryKey", serviceDiscoveryNames);
        return ddEvent;
    }

    public static RegistryEvent toSsEvent(ApplicationModel applicationModel, String serviceKey, List<String> serviceDiscoveryNames) {
        RegistryEvent ddEvent = new RegistryEvent(applicationModel, SS_EVENT);
        ddEvent.putAttachment("serviceKey", serviceKey);
        ddEvent.putAttachment("size", 1);
        ddEvent.putAttachment("registryKey", serviceDiscoveryNames);
        return ddEvent;
    }

    public static RegistryEvent refreshDirectoryEvent(ApplicationModel applicationModel, Map<MetricsKey, Map<String, Integer>> summaryMap, Map<String, String> attachments) {
        RegistryEvent registryEvent = new RegistryEvent(applicationModel, DIRECTORY_EVENT);
        registryEvent.putAttachment("dirNum", summaryMap);
        registryEvent.putAttachments(attachments);
        return registryEvent;
    }
}

