/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.acl;

import com.ecwid.consul.ConsulException;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.HttpResponse;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.acl.AclClient;
import com.ecwid.consul.v1.acl.model.Acl;
import com.ecwid.consul.v1.acl.model.NewAcl;
import com.ecwid.consul.v1.acl.model.UpdateAcl;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public final class AclConsulClient
implements AclClient {
    private final ConsulRawClient rawClient;

    public AclConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public AclConsulClient() {
        this(new ConsulRawClient());
    }

    public AclConsulClient(TLSConfig tlsConfig) {
        this(new ConsulRawClient(tlsConfig));
    }

    public AclConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public AclConsulClient(String agentHost, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, tlsConfig));
    }

    public AclConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    public AclConsulClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, agentPort, tlsConfig));
    }

    @Override
    public Response<String> aclCreate(NewAcl newAcl, String token) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        String json = GsonFactory.getGson().toJson((Object)newAcl);
        HttpResponse httpResponse = this.rawClient.makePutRequest("/v1/acl/create", json, tokenParams);
        if (httpResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(httpResponse.getContent(), new TypeToken<Map<String, String>>(){}.getType());
            return new Response<String>((String)value.get("ID"), httpResponse);
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<Void> aclUpdate(UpdateAcl updateAcl, String token) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        String json = GsonFactory.getGson().toJson((Object)updateAcl);
        HttpResponse httpResponse = this.rawClient.makePutRequest("/v1/acl/update", json, tokenParams);
        if (httpResponse.getStatusCode() == 200) {
            return new Response<Object>(null, httpResponse);
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<Void> aclDestroy(String aclId, String token) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        HttpResponse httpResponse = this.rawClient.makePutRequest("/v1/acl/destroy/" + aclId, "", tokenParams);
        if (httpResponse.getStatusCode() == 200) {
            return new Response<Object>(null, httpResponse);
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<Acl> getAcl(String id) {
        HttpResponse httpResponse = this.rawClient.makeGetRequest("/v1/acl/info/" + id, new UrlParameters[0]);
        if (httpResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(httpResponse.getContent(), new TypeToken<List<Acl>>(){}.getType());
            if (value.isEmpty()) {
                return new Response<Object>(null, httpResponse);
            }
            if (value.size() == 1) {
                return new Response<Acl>((Acl)value.get(0), httpResponse);
            }
            throw new ConsulException("Strange response (list size=" + value.size() + ")");
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<String> aclClone(String aclId, String token) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        HttpResponse httpResponse = this.rawClient.makePutRequest("/v1/acl/clone/" + aclId, "", tokenParams);
        if (httpResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(httpResponse.getContent(), new TypeToken<Map<String, String>>(){}.getType());
            return new Response<String>((String)value.get("ID"), httpResponse);
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<List<Acl>> getAclList(String token) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        HttpResponse httpResponse = this.rawClient.makeGetRequest("/v1/acl/list", tokenParams);
        if (httpResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(httpResponse.getContent(), new TypeToken<List<Acl>>(){}.getType());
            return new Response<List<Acl>>(value, httpResponse);
        }
        throw new OperationException(httpResponse);
    }
}

