/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class URIDataStoreProvider
extends DataStoreProvider {
    public static final ParameterDescriptor<URI> LOCATION_PARAM;
    public static final ParameterDescriptor<Path> METADATA_PARAM;
    public static final ParameterDescriptor<Boolean> CREATE_PARAM;
    public static final ParameterDescriptor<Charset> ENCODING;
    private volatile ParameterDescriptorGroup openDescriptor;

    protected URIDataStoreProvider() {
    }

    @Override
    public final ParameterDescriptorGroup getOpenParameters() {
        ParameterDescriptorGroup desc = this.openDescriptor;
        if (desc == null) {
            this.openDescriptor = desc = this.build((ParameterBuilder)new ParameterBuilder().addName((CharSequence)this.getShortName()));
        }
        return desc;
    }

    protected ParameterDescriptorGroup build(ParameterBuilder builder) {
        return builder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM, METADATA_PARAM});
    }

    public static ParameterDescriptorGroup descriptor(String name) {
        return ((ParameterBuilder)new ParameterBuilder().addName((CharSequence)name)).createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
    }

    public static Object location(Resource resource) throws DataStoreException {
        Optional<ParameterValueGroup> p;
        if (resource instanceof DataStore && (p = ((DataStore)resource).getOpenParameters()).isPresent()) {
            try {
                return p.get().parameter("location").getValue();
            }
            catch (ParameterNotFoundException e) {
                Logging.recoverableException((Logger)StoreUtilities.LOGGER, URIDataStore.class, (String)"location", (Throwable)e);
            }
        }
        return resource.getFileSet().flatMap(files -> files.getPaths().stream().findFirst()).orElse(null);
    }

    public static StorageConnector connector(DataStoreProvider provider, ParameterValueGroup parameters) throws IllegalOpenParameterException {
        ParameterNotFoundException cause = null;
        if (parameters != null) {
            try {
                Object location = parameters.parameter("location").getValue();
                if (location != null) {
                    return new StorageConnector(location);
                }
            }
            catch (ParameterNotFoundException e) {
                cause = e;
            }
        }
        throw new IllegalOpenParameterException(Resources.format((short)27, provider.getShortName(), "location"), cause);
    }

    public static boolean isWritable(StorageConnector connector, boolean ifNew) throws DataStoreException {
        Object storage = connector.getStorage();
        if (storage instanceof OutputStream || storage instanceof DataOutput) {
            return true;
        }
        if (storage instanceof InputStream || storage instanceof DataInput) {
            return false;
        }
        Object[] options = (OpenOption[])connector.getOption(OptionKey.OPEN_OPTIONS);
        if (ArraysExt.contains((Object[])options, (Object)StandardOpenOption.WRITE)) {
            if (!ifNew || ArraysExt.contains((Object[])options, (Object)StandardOpenOption.TRUNCATE_EXISTING)) {
                return true;
            }
            if (ArraysExt.contains((Object[])options, (Object)StandardOpenOption.CREATE_NEW)) {
                return IOUtilities.isKindOfPath(storage);
            }
            if (ArraysExt.contains((Object[])options, (Object)StandardOpenOption.CREATE)) {
                try {
                    Path path = connector.getStorageAs(Path.class);
                    return path != null && IOUtilities.isAbsentOrEmpty(path);
                }
                catch (IOException e) {
                    throw new DataStoreException(e);
                }
            }
        }
        return false;
    }

    public static ChannelDataOutput openAndSetNativeByteOrder(StorageConnector connector, String format) throws DataStoreException {
        Object storage = connector.getStorage();
        ChannelDataOutput output = connector.commit(ChannelDataOutput.class, format);
        if (output != storage && !(storage instanceof Buffer)) {
            output.buffer.order(ByteOrder.nativeOrder());
        }
        return output;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        ENCODING = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"encoding")).setDescription((CharSequence)Resources.formatInternational((short)29))).create(Charset.class, null);
        CREATE_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"create")).setDescription((CharSequence)Resources.formatInternational((short)51))).create(Boolean.class, null);
        METADATA_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"metadata")).setDescription((CharSequence)Resources.formatInternational((short)81))).create(Path.class, null);
        LOCATION_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"location")).setDescription((CharSequence)Resources.formatInternational((short)31))).setRequired(true).create(URI.class, null);
    }
}

