/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.grpc;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.grpc.GRPCConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.grpc.RemoteEndpointSettings;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class GRPCConfigurationProvider
extends AbstractConfigurationProvider {
    private RemoteEndpointSettings settings;

    public String name() {
        return "grpc";
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<RemoteEndpointSettings>(){

            public Class type() {
                return RemoteEndpointSettings.class;
            }

            public void onInitialized(RemoteEndpointSettings initialized) {
                GRPCConfigurationProvider.this.settings = initialized;
            }
        };
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)this.settings.getHost())) {
            throw new ModuleStartException("No host setting.");
        }
        if (this.settings.getPort() < 1) {
            throw new ModuleStartException("No port setting.");
        }
        return new GRPCConfigWatcherRegister(this.settings);
    }
}

