/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.ElectionType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ApiError;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ElectLeadersResponse;

public class ElectLeadersRequest
extends AbstractRequest {
    private final ElectLeadersRequestData data;

    private ElectLeadersRequest(ElectLeadersRequestData data, short version) {
        super(ApiKeys.ELECT_LEADERS, version);
        this.data = data;
    }

    @Override
    public ElectLeadersRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
        if (this.data.topicPartitions() != null) {
            for (ElectLeadersRequestData.TopicPartitions topic : this.data.topicPartitions()) {
                ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
                electionResult.setTopic(topic.topic());
                for (Integer partitionId : topic.partitions()) {
                    ElectLeadersResponseData.PartitionResult partitionResult = new ElectLeadersResponseData.PartitionResult();
                    partitionResult.setPartitionId(partitionId);
                    partitionResult.setErrorCode(apiError.error().code());
                    partitionResult.setErrorMessage(apiError.message());
                    electionResult.partitionResult().add(partitionResult);
                }
                electionResults.add(electionResult);
            }
        }
        return new ElectLeadersResponse(throttleTimeMs, apiError.error().code(), electionResults, this.version());
    }

    public static ElectLeadersRequest parse(ByteBuffer buffer, short version) {
        return new ElectLeadersRequest(new ElectLeadersRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ElectLeadersRequest> {
        private final ElectionType electionType;
        private final Collection<TopicPartition> topicPartitions;
        private final int timeoutMs;

        public Builder(ElectionType electionType, Collection<TopicPartition> topicPartitions, int timeoutMs) {
            super(ApiKeys.ELECT_LEADERS);
            this.electionType = electionType;
            this.topicPartitions = topicPartitions;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public ElectLeadersRequest build(short version) {
            return new ElectLeadersRequest(this.toRequestData(version), version);
        }

        public String toString() {
            return "ElectLeadersRequest(electionType=" + (Object)((Object)this.electionType) + ", topicPartitions=" + (this.topicPartitions == null ? "null" : MessageUtil.deepToString(this.topicPartitions.iterator())) + ", timeoutMs=" + this.timeoutMs + ")";
        }

        private ElectLeadersRequestData toRequestData(short version) {
            if (this.electionType != ElectionType.PREFERRED && version == 0) {
                throw new UnsupportedVersionException("API Version 0 only supports PREFERRED election type");
            }
            ElectLeadersRequestData data = new ElectLeadersRequestData().setTimeoutMs(this.timeoutMs);
            if (this.topicPartitions != null) {
                this.topicPartitions.forEach(tp -> {
                    ElectLeadersRequestData.TopicPartitions tps = data.topicPartitions().find(tp.topic());
                    if (tps == null) {
                        tps = new ElectLeadersRequestData.TopicPartitions().setTopic(tp.topic());
                        data.topicPartitions().add(tps);
                    }
                    tps.partitions().add(tp.partition());
                });
            } else {
                data.setTopicPartitions(null);
            }
            data.setElectionType(this.electionType.value);
            return data;
        }
    }
}

