/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffledb;

import java.io.IOException;
import org.apache.spark.network.shuffledb.DB;
import org.apache.spark.network.shuffledb.DBIterator;
import org.apache.spark.network.shuffledb.RocksDBIterator;
import org.rocksdb.RocksDBException;
import org.sparkproject.guava.base.Throwables;

public class RocksDB
implements DB {
    private final org.rocksdb.RocksDB db;

    public RocksDB(org.rocksdb.RocksDB db) {
        this.db = db;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        try {
            this.db.put(key, value);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void delete(byte[] key) {
        try {
            this.db.delete(key);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public DBIterator iterator() {
        return new RocksDBIterator(this.db.newIterator());
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }
}

