/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.Serializable;
import java.util.ArrayList;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.python.SerDeUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class SerDeUtil$
implements Logging {
    public static SerDeUtil$ MODULE$;
    private boolean initialized;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SerDeUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public synchronized void initialize() {
        if (!this.initialized()) {
            Unpickler.registerConstructor((String)"__builtin__", (String)"bytearray", (IObjectConstructor)new SerDeUtil.ByteArrayConstructor());
            Unpickler.registerConstructor((String)"builtins", (String)"bytearray", (IObjectConstructor)new SerDeUtil.ByteArrayConstructor());
            Unpickler.registerConstructor((String)"__builtin__", (String)"bytes", (IObjectConstructor)new SerDeUtil.ByteArrayConstructor());
            Unpickler.registerConstructor((String)"_codecs", (String)"encode", (IObjectConstructor)new SerDeUtil.ByteArrayConstructor());
            this.initialized_$eq(true);
            return;
        }
    }

    public JavaRDD<Object> toJavaArray(JavaRDD<Object> jrdd) {
        return jrdd.rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                return arrayList.toArray();
            }
            if (object.getClass().isArray()) {
                return Predef$.MODULE$.genericArrayOps(object).toArray(ClassTag$.MODULE$.apply(Object.class));
            }
            throw new MatchError(object);
        }, ClassTag$.MODULE$.apply(Object.class)).toJavaRDD();
    }

    public JavaRDD<byte[]> javaToPython(JavaRDD<?> jRDD) {
        return JavaRDD$.MODULE$.fromRDD(jRDD.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> new SerDeUtil.AutoBatchedPickler((Iterator<Object>)iter), jRDD.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<Object> pythonToJava(JavaRDD<byte[]> pyRDD, boolean batched) {
        return pyRDD.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            MODULE$.initialize();
            Unpickler unpickle = new Unpickler();
            return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Object obj = unpickle.loads(row);
                if (batched) {
                    Object object = obj;
                    if (object instanceof Object[]) {
                        Object[] objectArray = (Object[])object;
                        return Predef$.MODULE$.genericArrayOps((Object)objectArray).toSeq();
                    }
                    return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)((ArrayList)obj)).asScala();
                }
                return (Seq)new .colon.colon(obj, (List)Nil$.MODULE$);
            });
        }, pyRDD.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.Any()).toJavaRDD();
    }

    private Tuple2<Object, Object> checkPickle(Tuple2<Object, Object> t) {
        Try try_;
        Try try_2;
        Try vt;
        Pickler pickle = new Pickler(true, false);
        Try kt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> pickle.dumps(t._1()));
        Tuple2 tuple2 = new Tuple2((Object)kt, (Object)(vt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> pickle.dumps(t._2()))));
        if (tuple2 != null) {
            Try try_3 = (Try)tuple2._1();
            Try try_4 = (Try)tuple2._2();
            if (try_3 instanceof Failure) {
                Failure failure = (Failure)try_3;
                Throwable kf = failure.exception();
                if (try_4 instanceof Failure) {
                    Failure failure2 = (Failure)try_4;
                    Throwable vf = failure2.exception();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("\n               |Failed to pickle Java object as key: ").append(t._1().getClass().getSimpleName()).append(", falling back\n               |to 'toString'. Error: ").append(kf.getMessage()).toString())).stripMargin());
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(109).append("\n               |Failed to pickle Java object as value: ").append(t._2().getClass().getSimpleName()).append(", falling back\n               |to 'toString'. Error: ").append(vf.getMessage()).toString())).stripMargin());
                    return new Tuple2.mcZZ.sp(true, true);
                }
            }
        }
        if (tuple2 != null && (try_2 = (Try)tuple2._1()) instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable kf = failure.exception();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("\n               |Failed to pickle Java object as key: ").append(t._1().getClass().getSimpleName()).append(", falling back\n               |to 'toString'. Error: ").append(kf.getMessage()).toString())).stripMargin());
            return new Tuple2.mcZZ.sp(true, false);
        }
        if (tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable vf = failure.exception();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(109).append("\n               |Failed to pickle Java object as value: ").append(t._2().getClass().getSimpleName()).append(", falling back\n               |to 'toString'. Error: ").append(vf.getMessage()).toString())).stripMargin());
            return new Tuple2.mcZZ.sp(false, true);
        }
        return new Tuple2.mcZZ.sp(false, false);
    }

    public RDD<byte[]> pairRDDToPython(RDD<Tuple2<Object, Object>> rdd, int batchSize) {
        Tuple2<Object, Object> tuple2;
        Tuple2[] tuple2Array = (Tuple2[])rdd.take(1);
        Option option = Array$.MODULE$.unapplySeq((Object)tuple2Array);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            tuple2 = new Tuple2<Object, Object>(false, false);
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)tuple2Array);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                Tuple2 first = (Tuple2)((SeqLike)option2.get()).apply(0);
                tuple2 = this.checkPickle((Tuple2<Object, Object>)first);
            } else {
                throw new MatchError((Object)tuple2Array);
            }
        }
        Tuple2<Object, Object> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean keyFailed = tuple22._1$mcZ$sp();
        boolean valueFailed = tuple22._2$mcZ$sp();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(keyFailed, valueFailed);
        boolean keyFailed2 = sp2._1$mcZ$sp();
        boolean valueFailed2 = sp2._2$mcZ$sp();
        return rdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator cleaned = iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    Object key = keyFailed2 ? k.toString() : k;
                    Object value = valueFailed2 ? v.toString() : v;
                    return new Object[]{key, value};
                }
                throw new MatchError((Object)tuple2);
            });
            if (batchSize == 0) {
                return new SerDeUtil.AutoBatchedPickler((Iterator<Object>)cleaned);
            }
            Pickler pickle = new Pickler(true, false);
            return cleaned.grouped(batchSize).map((Function1 & Serializable & scala.Serializable)batched -> pickle.dumps(JavaConverters$.MODULE$.seqAsJavaListConverter(batched).asJava()));
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public <K, V> RDD<Tuple2<K, V>> pythonToPairRDD(RDD<byte[]> pyRDD, boolean batched) {
        Object obj2;
        RDD<Object> rdd = this.pythonToJava(JavaRDD$.MODULE$.fromRDD(pyRDD, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), batched).rdd();
        Object[] objectArray = (Object[])rdd.take(1);
        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && SerDeUtil$.isPair$1(obj2 = ((SeqLike)option.get()).apply(0))) {
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)objectArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(0) == 0) {
            } else {
                Option option3 = Array$.MODULE$.unapplySeq((Object)objectArray);
                if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(1) == 0) {
                    Object other = ((SeqLike)option3.get()).apply(0);
                    throw new SparkException(new StringBuilder(35).append("RDD element of type ").append(other.getClass().getName()).append(" cannot be used").toString());
                }
                throw new MatchError((Object)objectArray);
            }
        }
        return rdd.map((Function1 & Serializable & scala.Serializable)obj -> {
            Object arr = obj;
            return new Tuple2(Predef$.MODULE$.genericArrayOps(arr).head(), Predef$.MODULE$.genericArrayOps(arr).last());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ boolean $anonfun$pythonToPairRDD$1(Class x$2) {
        return !x$2.isPrimitive();
    }

    private static final boolean isPair$1(Object obj) {
        return Option$.MODULE$.apply(obj.getClass().getComponentType()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SerDeUtil$.$anonfun$pythonToPairRDD$1(x$2))) && ScalaRunTime$.MODULE$.array_length(obj) == 2;
    }

    private SerDeUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.initialized = false;
        this.initialize();
    }
}

